/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.misc.placeholder;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.ui.misc.placeholder.AbstractPlaceholder;
import org.richfaces.ui.misc.placeholder.PlaceholderRendererBase;

public class PlaceholderRenderer
extends PlaceholderRendererBase {
    private static final RenderKitUtils.Attributes ATTRIBUTES_FOR_SCRIPT_HASH35 = RenderKitUtils.attributes().generic("styleClass", "styleClass", new String[0]);

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return object.toString().length() == 0;
    }

    @Override
    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractPlaceholder component = (AbstractPlaceholder)uiComponent;
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("span", (UIComponent)component);
        String value = clientId;
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        responseWriter.startElement("script", (UIComponent)component);
        value = PlaceholderRenderer.convertToString(clientId) + "Script";
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        responseWriter.writeAttribute("type", (Object)"text/javascript", null);
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        RenderKitUtils.addToScriptHash(options, facesContext, (UIComponent)component, ATTRIBUTES_FOR_SCRIPT_HASH35, null);
        RenderKitUtils.addToScriptHash(options, "targetId", PlaceholderRenderer.isEmpty(component.getSelector()) ? component.getParent().getClientId() : null, null, null);
        RenderKitUtils.addToScriptHash(options, "selector", !PlaceholderRenderer.isEmpty(component.getSelector()) ? component.getSelector() : null, null, null);
        RenderKitUtils.addToScriptHash(options, "text", this.getConvertedValue(facesContext, component), null, null);
        String text = "new RichFaces.ui.Placeholder(\"" + PlaceholderRenderer.convertToString(clientId) + "\", " + PlaceholderRenderer.convertToString(RenderKitUtils.toScriptArgs(options)) + ");";
        if (text != null) {
            responseWriter.writeText((Object)text, null);
        }
        responseWriter.endElement("script");
        responseWriter.endElement("span");
    }
}

