/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.output.chart;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.richfaces.json.JSONArray;
import org.richfaces.json.JSONObject;
import org.richfaces.ui.output.chart.ChartRendererBase;
import org.richfaces.ui.output.chart.ChartStrategy;

public abstract class ChartDataModel<T, S> {
    private Map<T, S> data = new HashMap<T, S>();
    protected ChartType type;
    protected ChartStrategy strategy;
    protected List<T> keys = new LinkedList<T>();
    private Map<String, Object> attributes;

    public ChartDataModel(ChartType type) {
        this.type = type;
    }

    public void setData(Map<T, S> data) {
        this.data = data;
    }

    public Map<T, S> getData() {
        return this.data;
    }

    public void put(T key, S value) {
        this.data.put(key, value);
        this.keys.add(key);
    }

    public void remove(T key) {
        this.data.remove(key);
        this.keys.remove(key);
    }

    public JSONObject defaultExport() throws IOException {
        JSONObject output = new JSONObject();
        JSONArray jsdata = new JSONArray();
        for (T key : this.keys) {
            JSONArray point = new JSONArray();
            S value = this.data.get(key);
            point.put(key);
            point.put(value);
            jsdata.put(point);
        }
        ChartRendererBase.addAttribute(output, "data", jsdata);
        ChartRendererBase.addAttribute(output, "label", this.getAttributes().get("label"));
        ChartRendererBase.addAttribute(output, "color", this.getAttributes().get("color"));
        return output;
    }

    public Object export() throws IOException {
        return this.strategy.export(this);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public ChartType getType() {
        return this.type;
    }

    public abstract Class getKeyType();

    public abstract Class getValueType();

    public static enum ChartType {
        line,
        bar,
        pie;

    }
}

