/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.output.chart;

import java.io.IOException;
import java.util.LinkedHashMap;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.ui.output.chart.AbstractChart;
import org.richfaces.ui.output.chart.ChartRendererBase;

@ResourceDependencies(value={@ResourceDependency(name="jsf.js", library="javax.faces", target=""), @ResourceDependency(name="jquery.js", library="org.richfaces", target=""), @ResourceDependency(name="richfaces.js", library="org.richfaces", target=""), @ResourceDependency(name="richfaces-queue.reslib", library="org.richfaces", target=""), @ResourceDependency(name="jquery.ui.core.js", library="com.jqueryui", target=""), @ResourceDependency(name="jquery.ui.widget.js", library="com.jqueryui", target=""), @ResourceDependency(name="jquery.flot.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.categories.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.pie.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.time.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.axislabels.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.symbol.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.orderBars.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.tooltip.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.selection.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.resize.js", library="flot", target=""), @ResourceDependency(name="output/chart.js", library="io.richwidgets", target=""), @ResourceDependency(name="output/chart.css", library="io.richwidgets", target=""), @ResourceDependency(name="bridge/bridge-base.js", library="org.richfaces", target=""), @ResourceDependency(name="bridge/output/chart-bridge.js", library="org.richfaces", target="")})
public class ChartRenderer
extends ChartRendererBase {
    private static final RenderKitUtils.Attributes ATTRIBUTES_FOR_SCRIPT_HASH23 = RenderKitUtils.attributes().generic("onplotclick", "onplotclick", "plotclick").generic("onplothover", "onplothover", "plothover").generic("onmouseout", "onmouseout", "mouseout");

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    @Override
    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractChart component = (AbstractChart)uiComponent;
        String clientId = component.getClientId(facesContext);
        LinkedHashMap<String, Object> events = new LinkedHashMap<String, Object>();
        RenderKitUtils.addToScriptHash(events, facesContext, (UIComponent)component, ATTRIBUTES_FOR_SCRIPT_HASH23, RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
        responseWriter.startElement("div", (UIComponent)component);
        String value = ChartRenderer.convertToString(component.getStyleClass()) + " chart-container";
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        responseWriter.startElement("div", (UIComponent)component);
        responseWriter.writeAttribute("class", (Object)"chart-title", null);
        String text = component.getTitle();
        if (text != null) {
            responseWriter.writeText((Object)text, null);
        }
        responseWriter.endElement("div");
        responseWriter.startElement("div", (UIComponent)component);
        responseWriter.writeAttribute("class", (Object)"chart", null);
        value = ChartRenderer.convertToString(clientId) + "Chart";
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        responseWriter.endElement("div");
        responseWriter.startElement("script", (UIComponent)component);
        responseWriter.writeAttribute("type", (Object)"text/javascript", null);
        text = "//\n\t                    RichFaces.jQuery(document.getElementById(\"" + ChartRenderer.convertToString(clientId) + "\")).chartBridge(\n\t                                   RichFaces.jQuery.extend({\n\t\t                                    handlers: RichFaces.jQuery.extend(" + ChartRenderer.convertToString(RenderKitUtils.toScriptArgs(events)) + "),\n\t\t                                    particularSeriesHandlers: " + ChartRenderer.convertToString(this.getParticularSeriesHandler(facesContext, (UIComponent)component)) + ",\n\t\t                                    data: " + ChartRenderer.convertToString(this.getChartData(facesContext, (UIComponent)component)) + ",\n\t                                    },\n\t                                    " + ChartRenderer.convertToString(this.getOpts(facesContext, (UIComponent)component)) + "\n\t                                   )\n\t                      );\n\t            //";
        if (text != null) {
            responseWriter.writeText((Object)text, null);
        }
        responseWriter.endElement("script");
        responseWriter.endElement("div");
    }
}

