/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.output.progressBar;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.ui.output.progressBar.AbstractProgressBar;
import org.richfaces.ui.output.progressBar.ProgressBarBaseRenderer;
import org.richfaces.ui.output.progressBar.ProgressBarState;
import org.richfaces.util.HtmlUtil;

public class ProgressBarStateEncoder {
    private static final int DEFAULT_MIN_VALUE = 0;
    private static final int DEFAULT_MAX_VALUE = 100;
    private boolean renderContentAsPlaceHolders;

    public ProgressBarStateEncoder(boolean renderContentAsPlaceHolders) {
        this.renderContentAsPlaceHolders = renderContentAsPlaceHolders;
    }

    protected String getContentStyle(boolean sameState) {
        return sameState ? null : "display: none";
    }

    private void encodeStateFacet(FacesContext context, UIComponent component, ProgressBarState state, ProgressBarState currentState) throws IOException {
        if (!state.hasContent(context, component)) {
            return;
        }
        String clientId = state.getStateClientId(context, component);
        ResponseWriter responseWriter = context.getResponseWriter();
        responseWriter.startElement("div", component);
        responseWriter.writeAttribute("class", (Object)state.getStyleClass(context, component), null);
        responseWriter.writeAttribute("id", (Object)clientId, null);
        responseWriter.writeAttribute("style", (Object)this.getContentStyle(state == currentState), null);
        if (!this.renderContentAsPlaceHolders || state == currentState) {
            state.encodeContent(context, component);
        }
        responseWriter.endElement("div");
    }

    public void encodeInitialState(FacesContext context, UIComponent component, ProgressBarState currentState) throws IOException {
        this.encodeStateFacet(context, component, ProgressBarState.initialState, currentState);
    }

    protected String getWidth(UIComponent component) {
        Number value = ProgressBarBaseRenderer.getNumber(this.getValueOrDefault(component));
        Number minValue = ProgressBarBaseRenderer.getNumber(this.getMinValueOrDefault(component));
        Number maxValue = ProgressBarBaseRenderer.getNumber(this.getMaxValueOrDefault(component));
        Number percent = this.calculatePercent(value, minValue, maxValue);
        return String.valueOf(percent.intValue());
    }

    protected Number calculatePercent(Number value, Number minValue, Number maxValue) {
        if (minValue.doubleValue() < value.doubleValue() && value.doubleValue() < maxValue.doubleValue()) {
            return (value.doubleValue() - minValue.doubleValue()) * 100.0 / (maxValue.doubleValue() - minValue.doubleValue());
        }
        if (value.doubleValue() <= minValue.doubleValue()) {
            return 0;
        }
        if (value.doubleValue() >= maxValue.doubleValue()) {
            return 100;
        }
        return 0;
    }

    public void encodeProgressStateContent(FacesContext context, UIComponent component, ProgressBarState currentState) throws IOException {
        if (!ProgressBarState.progressState.hasContent(context, component)) {
            return;
        }
        ResponseWriter responseWriter = context.getResponseWriter();
        String stateClientId = ProgressBarState.progressState.getStateClientId(context, component);
        responseWriter.startElement("div", component);
        responseWriter.writeAttribute("class", (Object)ProgressBarState.progressState.getStyleClass(context, component), null);
        responseWriter.writeAttribute("id", (Object)stateClientId, null);
        if (!this.renderContentAsPlaceHolders || currentState == ProgressBarState.progressState) {
            ProgressBarState.progressState.encodeContent(context, component);
        }
        responseWriter.endElement("div");
    }

    protected void encodeProgressStateProlog(FacesContext context, UIComponent component, ProgressBarState currentState) throws IOException {
        ResponseWriter responseWriter = context.getResponseWriter();
        responseWriter.startElement("div", component);
        responseWriter.writeAttribute("id", (Object)(component.getClientId(context) + ".rmng"), null);
        responseWriter.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-pb-rmng", component.getAttributes().get("remainingClass")), null);
        responseWriter.writeAttribute("style", (Object)this.getContentStyle(currentState == ProgressBarState.progressState), null);
        responseWriter.startElement("div", component);
        responseWriter.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-pb-prgs", component.getAttributes().get("progressClass")), null);
        responseWriter.writeAttribute("id", (Object)(component.getClientId(context) + ".prgs"), null);
        responseWriter.writeAttribute("style", (Object)("width: " + this.getWidth(component) + "%"), null);
        responseWriter.endElement("div");
    }

    protected void encodeProgressStateEpilog(FacesContext context, UIComponent component, ProgressBarState currentState) throws IOException {
        ResponseWriter responseWriter = context.getResponseWriter();
        responseWriter.endElement("div");
    }

    public void encodeProgressState(FacesContext context, UIComponent component, ProgressBarState currentState) throws IOException {
        this.encodeProgressStateProlog(context, component, currentState);
        this.encodeProgressStateContent(context, component, currentState);
        this.encodeProgressStateEpilog(context, component, currentState);
    }

    public void encodeCompleteState(FacesContext context, UIComponent component, ProgressBarState currentState) throws IOException {
        this.encodeStateFacet(context, component, ProgressBarState.finishState, currentState);
    }

    protected Object getMaxValueOrDefault(UIComponent component) {
        Object maxValue = ((AbstractProgressBar)component).getMaxValue();
        if (maxValue == null) {
            maxValue = 100;
        }
        return maxValue;
    }

    protected Object getMinValueOrDefault(UIComponent component) {
        Object maxValue = ((AbstractProgressBar)component).getMinValue();
        if (maxValue == null) {
            maxValue = 0;
        }
        return maxValue;
    }

    protected Object getValueOrDefault(UIComponent component) {
        Object value = ((AbstractProgressBar)component).getValue();
        if (value == null) {
            value = Integer.MIN_VALUE;
        }
        return value;
    }
}

