/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.select;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.ui.select.AbstractSelectManyComponent;
import org.richfaces.ui.select.ClientSelectItem;
import org.richfaces.ui.select.SelectHelper;
import org.richfaces.ui.select.SelectItemsInterface;
import org.richfaces.ui.select.SelectManyRendererBase;
import org.richfaces.ui.select.SelectUtils;

public class SelectManyHelper {
    private static final Logger LOG = RichfacesLogger.APPLICATION.getLogger();
    public static Comparator<ClientSelectItem> clientSelectItemComparator = new Comparator<ClientSelectItem>(){

        @Override
        public int compare(ClientSelectItem clientSelectItem, ClientSelectItem clientSelectItem1) {
            Integer sortOrder = clientSelectItem == null || clientSelectItem.getSortOrder() == null ? 0 : clientSelectItem.getSortOrder();
            Integer sortOrder1 = clientSelectItem1 == null || clientSelectItem1.getSortOrder() == null ? 0 : clientSelectItem1.getSortOrder();
            return sortOrder.compareTo(sortOrder1);
        }
    };
    public static Predicate<ClientSelectItem> SELECTED_PREDICATE = new Predicate<ClientSelectItem>(){

        public boolean apply(@Nullable ClientSelectItem clientSelectItem) {
            return clientSelectItem.isSelected();
        }
    };
    public static Predicate<ClientSelectItem> UNSELECTED_PREDICATE = Predicates.not(SELECTED_PREDICATE);

    public static List<ClientSelectItem> getClientSelectItems(FacesContext facesContext, AbstractSelectManyComponent select, Iterator<SelectItem> selectItems) {
        List<Object> values;
        ArrayList<ClientSelectItem> clientSelectItems = new ArrayList<ClientSelectItem>();
        Object object = select.getValue();
        if (object == null) {
            values = new ArrayList();
        } else if (object instanceof List) {
            values = (List)object;
        } else if (object instanceof Object[]) {
            values = Arrays.asList((Object[])object);
        } else {
            throw new IllegalArgumentException("Value expression must evaluate to either a List or Object[]");
        }
        int count = values.size();
        while (selectItems.hasNext()) {
            int sortOrder;
            boolean selected;
            SelectItem selectItem = selectItems.next();
            if (values.contains(selectItem.getValue())) {
                selected = true;
                sortOrder = values.indexOf(selectItem.getValue());
            } else {
                selected = false;
                sortOrder = count;
            }
            ClientSelectItem clientSelectItem = SelectHelper.generateClientSelectItem(facesContext, (UIComponent)select, selectItem, sortOrder, selected);
            clientSelectItems.add(clientSelectItem);
            if (selected) continue;
            ++count;
        }
        Collections.sort(clientSelectItems, clientSelectItemComparator);
        return clientSelectItems;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getConvertedValue(FacesContext facesContext, UIComponent component, Object val) throws ConverterException {
        void var6_19;
        Converter converter;
        String[] values;
        block18: {
            values = val == null ? new String[]{} : (String[])val;
            converter = SelectManyHelper.getItemConverter(facesContext, component);
            ValueExpression ve = component.getValueExpression("value");
            Object var6_6 = null;
            if (ve != null) {
                Class<?> modelType = ve.getType(facesContext.getELContext());
                if (modelType.isArray()) {
                    Class<?> arrayComponentType = modelType.getComponentType();
                    Object object = Array.newInstance(arrayComponentType, values.length);
                } else {
                    void var6_10;
                    if (!Collection.class.isAssignableFrom(modelType) && !Object.class.equals((Object)modelType)) throw new FacesException("ValueExpression must be either an Array, or a Collection");
                    String collectionType = (String)component.getAttributes().get("collectionType");
                    if (collectionType != null) {
                        Class collectionClass = SelectManyHelper.getCollectionClass(collectionType);
                        try {
                            Object t = collectionClass.newInstance();
                        }
                        catch (Exception e) {
                            throw new FacesException((Throwable)e);
                        }
                    }
                    Collection value = (Collection)((EditableValueHolder)component).getValue();
                    if (value instanceof Cloneable) {
                        try {
                            Collection collection = (Collection)value.getClass().getMethod("clone", new Class[0]).invoke((Object)value, new Object[0]);
                            collection.clear();
                        }
                        catch (Exception e) {
                            LOG.log(Logger.Level.WARNING, "Unable to clone collection");
                        }
                    }
                    if (var6_10 == null) {
                        Class<?> collectionClass = value == null ? modelType : value.getClass();
                        try {
                            Object obj = collectionClass.newInstance();
                            ((Collection)obj).clear();
                        }
                        catch (Exception e) {
                            if (!Collection.class.isAssignableFrom(modelType)) break block18;
                            if (SortedSet.class.isAssignableFrom(modelType)) {
                                TreeSet treeSet = new TreeSet();
                                break block18;
                            }
                            if (Queue.class.isAssignableFrom(modelType)) {
                                LinkedList linkedList = new LinkedList();
                                break block18;
                            }
                            if (Set.class.isAssignableFrom(modelType)) {
                                HashSet hashSet = new HashSet(values.length);
                                break block18;
                            }
                            ArrayList arrayList = new ArrayList(values.length);
                        }
                    }
                }
            } else {
                Object[] objectArray = new Object[values.length];
            }
        }
        for (int i = 0; i < values.length; ++i) {
            Object value = converter == null ? values[i] : converter.getAsObject(facesContext, component, values[i]);
            if (var6_19.getClass().isArray()) {
                Array.set(var6_19, i, value);
                continue;
            }
            ((Collection)var6_19).add(value);
        }
        return var6_19;
    }

    private static Class getCollectionClass(String collectionType) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<Collection> collectionClass = null;
        if (classLoader == null) {
            classLoader = SelectManyRendererBase.class.getClassLoader();
        }
        try {
            collectionClass = classLoader.loadClass(collectionType).asSubclass(Collection.class);
        }
        catch (ClassNotFoundException e) {
            throw new FacesException((Throwable)e);
        }
        return collectionClass;
    }

    public static Converter getItemConverter(FacesContext facesContext, UIComponent component) {
        Class valueType;
        Converter converter = null;
        if (component instanceof ValueHolder && (converter = ((ValueHolder)component).getConverter()) != null) {
            return converter;
        }
        ValueExpression ve = component.getValueExpression("value");
        if (ve != null && (valueType = ve.getType(facesContext.getELContext())) != null && valueType.isArray()) {
            converter = facesContext.getApplication().createConverter(valueType);
        }
        if (converter == null) {
            Iterator<SelectItem> selectItems = SelectUtils.getSelectItems(facesContext, component);
            converter = SelectManyHelper.getSelectItemConverter(facesContext.getApplication(), selectItems);
        }
        return converter;
    }

    public static Converter getSelectItemConverter(Application facesApplication, Iterator<SelectItem> selectItems) {
        Converter converter = null;
        while (selectItems.hasNext() && converter == null) {
            SelectItem selectItem = selectItems.next();
            if (selectItem instanceof SelectItemGroup) {
                SelectItemGroup selectItemGroup = (SelectItemGroup)selectItem;
                UnmodifiableIterator groupSelectItems = Iterators.forArray((Object[])selectItemGroup.getSelectItems());
                converter = SelectManyHelper.getSelectItemConverter(facesApplication, (Iterator<SelectItem>)groupSelectItems);
                continue;
            }
            Class<?> selectItemClass = selectItem.getValue().getClass();
            if (String.class.equals(selectItemClass)) {
                return null;
            }
            try {
                converter = facesApplication.createConverter(selectItemClass);
            }
            catch (FacesException exception) {}
        }
        return converter;
    }

    public static UISelectItems getPseudoSelectItems(SelectItemsInterface selectItemsInterface) {
        UISelectItems selectItems = null;
        if (selectItemsInterface.getVar() != null && selectItemsInterface.getItemValues() != null) {
            selectItems = new UISelectItems();
            selectItems.setValue(selectItemsInterface.getItemValues());
            selectItems.getAttributes().put("var", selectItemsInterface.getVar());
            if (selectItemsInterface.getItemValue() != null) {
                selectItems.getAttributes().put("itemValue", selectItemsInterface.getItemValue());
            }
            if (selectItemsInterface.getItemLabel() != null) {
                selectItems.getAttributes().put("itemLabel", selectItemsInterface.getItemLabel());
            }
        }
        return selectItems;
    }
}

