/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.select;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.richfaces.ui.input.InputRendererBase;
import org.richfaces.ui.select.AbstractSelectManyComponent;
import org.richfaces.ui.select.ClientSelectItem;
import org.richfaces.ui.select.SelectManyHelper;
import org.richfaces.ui.select.SelectUtils;

public class SelectManyRendererBase
extends InputRendererBase {
    private static final String HIDDEN_SUFFIX = "Hidden";

    public List<ClientSelectItem> getClientSelectItems(FacesContext facesContext, UIComponent component) {
        AbstractSelectManyComponent select = (AbstractSelectManyComponent)component;
        return SelectManyHelper.getClientSelectItems(facesContext, select, SelectUtils.getSelectItems(facesContext, component));
    }

    public String csvEncodeSelectedItems(List<ClientSelectItem> clientSelectItems) {
        if (clientSelectItems == null || clientSelectItems.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ClientSelectItem item : clientSelectItems) {
            if (!item.isSelected()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(item.getConvertedValue());
        }
        return sb.toString();
    }

    @Override
    protected void doDecode(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof AbstractSelectManyComponent)) {
            throw new IllegalArgumentException(String.format("Component %s is not an AbstractSelectManyComponent", component.getClientId(facesContext)));
        }
        AbstractSelectManyComponent picklist = (AbstractSelectManyComponent)component;
        String hiddenClientId = picklist.getClientId(facesContext);
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (picklist.isDisabled()) {
            return;
        }
        String value = (String)paramMap.get(hiddenClientId);
        if (value != null) {
            if (value.trim().equals("")) {
                picklist.setSubmittedValue(new String[0]);
            } else {
                String[] reqValues = value.split(",");
                picklist.setSubmittedValue(reqValues);
            }
        } else {
            picklist.setSubmittedValue(new String[0]);
        }
    }

    @Override
    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object val) throws ConverterException {
        return SelectManyHelper.getConvertedValue(facesContext, component, val);
    }

    public boolean hasColumnChildren(FacesContext facesContext, UIComponent component) {
        AbstractSelectManyComponent select = (AbstractSelectManyComponent)component;
        return select.columns().hasNext();
    }

    public boolean isHeaderExists(FacesContext facesContext, UIComponent component) {
        AbstractSelectManyComponent select = (AbstractSelectManyComponent)component;
        Iterator<UIColumn> columnIterator = select.columns();
        while (columnIterator.hasNext()) {
            UIColumn column = columnIterator.next();
            if (column.getFacet("header") == null) continue;
            return true;
        }
        return false;
    }
}

