/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.select.select;

import java.io.IOException;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.javascript.JSReference;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.javascript.ScriptString;
import org.richfaces.l10n.FacesMessages;
import org.richfaces.l10n.MessageFactory;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.services.ServiceTracker;
import org.richfaces.ui.input.InputRendererBase;
import org.richfaces.ui.select.AbstractSelectComponent;
import org.richfaces.ui.select.ClientSelectItem;
import org.richfaces.ui.select.SelectHelper;
import org.richfaces.ui.select.select.AbstractSelect;
import org.richfaces.ui.validation.AddCSVMessageScript;
import org.richfaces.util.HtmlDimensions;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="common/richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="common/jquery.position.js"), @ResourceDependency(library="org.richfaces", name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="common/richfaces-utils.js"), @ResourceDependency(library="org.richfaces", name="common/richfaces-selection.js"), @ResourceDependency(library="org.richfaces", name="common/inputBase.js"), @ResourceDependency(library="org.richfaces", name="common/popup.js"), @ResourceDependency(library="org.richfaces", name="select/list.js"), @ResourceDependency(library="org.richfaces", name="select/popupList.js"), @ResourceDependency(library="org.richfaces", name="select/select/select.js"), @ResourceDependency(library="org.richfaces", name="select/select/select.ecss")})
public class SelectRendererBase
extends InputRendererBase {
    public static final String ITEM_CSS = "rf-sel-opt";

    public JSReference getClientFilterFunction(UIComponent component) {
        AbstractSelect select = (AbstractSelect)component;
        String clientFilter = (String)select.getAttributes().get("clientFilterFunction");
        if (clientFilter != null && clientFilter.length() != 0) {
            return new JSReference(clientFilter);
        }
        return null;
    }

    public void renderListHandlers(FacesContext facesContext, UIComponent component) throws IOException {
        RenderKitUtils.renderPassThroughAttributesOptimized(facesContext, component, SelectHelper.SELECT_LIST_HANDLER_ATTRIBUTES);
    }

    public List<ClientSelectItem> getConvertedSelectItems(FacesContext facesContext, UIComponent component) {
        return SelectHelper.getConvertedSelectItems(facesContext, component);
    }

    public String getSelectInputLabel(FacesContext facesContext, UIComponent component) {
        return SelectHelper.getSelectInputLabel(facesContext, component);
    }

    protected String getMinListHeight(AbstractSelect select) {
        String height = HtmlDimensions.formatSize(select.getMinListHeight());
        if (height == null || height.length() == 0) {
            height = "20px";
        }
        return height;
    }

    protected String getMaxListHeight(AbstractSelect select) {
        String height = HtmlDimensions.formatSize(select.getMaxListHeight());
        if (height == null || height.length() == 0) {
            height = "100px";
        }
        return height;
    }

    protected String getListHeight(AbstractSelect select) {
        String height = HtmlDimensions.formatSize(select.getListHeight());
        if (height == null || height.length() == 0) {
            height = "auto";
        }
        return height;
    }

    protected String getListWidth(AbstractSelect select) {
        String width = HtmlDimensions.formatSize(select.getListWidth());
        if (width == null || width.length() == 0) {
            width = "200px";
        }
        return width;
    }

    public String encodeHeightAndWidth(UIComponent component) {
        AbstractSelect select = (AbstractSelect)component;
        String height = this.getListHeight(select);
        if (!"auto".equals(height)) {
            height = height != null && height.trim().length() != 0 ? "height: " + height : "";
        } else {
            String minHeight = this.getMinListHeight(select);
            minHeight = minHeight != null && minHeight.trim().length() != 0 ? "min-height: " + minHeight : "";
            String maxHeight = this.getMaxListHeight(select);
            maxHeight = maxHeight != null && maxHeight.trim().length() != 0 ? "max-height: " + maxHeight : "";
            height = this.concatStyles(minHeight, maxHeight);
        }
        String width = this.getListWidth(select);
        width = width != null && width.trim().length() != 0 ? "width: " + width : "";
        return this.concatStyles(height, width);
    }

    public String getListCss(UIComponent component) {
        AbstractSelect inplaceSelect = (AbstractSelect)component;
        String css = inplaceSelect.getListClass();
        css = css != null ? this.concatClasses("rf-sel-lst-cord", css) : "rf-sel-lst-cord";
        return css;
    }

    public String getSelectLabel(FacesContext facesContext, UIComponent component) {
        AbstractSelectComponent select = (AbstractSelectComponent)component;
        String label = this.getSelectInputLabel(facesContext, (UIComponent)select);
        if (label == null || "".equals(label.trim())) {
            label = select.getDefaultLabel();
        }
        return label;
    }

    public void encodeItems(FacesContext facesContext, UIComponent component, List<ClientSelectItem> clientSelectItems) throws IOException {
        SelectHelper.encodeItems(facesContext, component, clientSelectItems, "div", ITEM_CSS);
    }

    @Override
    protected void preEncodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ScriptString script = this.prepareCSVMessageScript(facesContext);
        JavaScriptService jsService = ServiceTracker.getService(JavaScriptService.class);
        jsService.addScript(facesContext, script);
    }

    private ScriptString prepareCSVMessageScript(FacesContext facesContext) {
        MessageFactory messageFactory = ServiceTracker.getService(MessageFactory.class);
        FacesMessage message = messageFactory.createMessage(facesContext, FacesMessage.SEVERITY_ERROR, FacesMessages.UISELECTONE_INVALID, "{0}");
        return new AddCSVMessageScript(FacesMessages.UISELECTONE_INVALID.name(), message);
    }
}

