/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.toggle.tabPanel;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.richfaces.javascript.JSObject;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.services.ServiceTracker;
import org.richfaces.ui.common.ComponentIterators;
import org.richfaces.ui.toggle.AbstractTogglePanelItemInterface;
import org.richfaces.ui.toggle.tabPanel.AbstractTab;
import org.richfaces.ui.toggle.tabPanel.AbstractTabPanel;
import org.richfaces.ui.toggle.togglePanel.TogglePanelItemRenderer;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="common/richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="toggle/togglePanel/togglePanelItem.js"), @ResourceDependency(library="org.richfaces", name="toggle/tabPanel/tab.js")})
public class TabRenderer
extends TogglePanelItemRenderer {
    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        AbstractTab tab = (AbstractTab)component;
        String compClientId = component.getClientId(context);
        if (requestMap.get(compClientId) != null) {
            AbstractTabPanel parentTabPanel = TabRenderer.getParentTabPanel(tab);
            if (parentTabPanel.isImmediate()) {
                tab.setImmediate(true);
            }
            new ActionEvent((UIComponent)tab).queue();
        }
    }

    @Override
    protected void doEncodeItemBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeItemBegin(writer, context, component);
        this.encodeContentBegin(context, component, writer);
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return this.concatClasses("rf-tab", TabRenderer.attributeAsString(component, "styleClass"));
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractTab tab = (AbstractTab)component;
        if (tab.shouldVisitChildren() && !tab.isDisabled()) {
            super.doEncodeChildren(writer, context, (UIComponent)tab);
        }
    }

    @Override
    protected void doEncodeItemEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.encodeContentEnd(component, writer);
        this.jsService().addScript(context, this.getScriptObject(context, component));
        writer.endElement("div");
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        if (((AbstractTogglePanelItemInterface)component).shouldVisitChildren()) {
            this.doEncodeItemEnd(writer, context, component);
        } else {
            this.encodePlaceHolder(context, component);
            this.jsService().addScript(context, this.getScriptObject(context, component));
        }
    }

    private JavaScriptService jsService() {
        return ServiceTracker.getService(JavaScriptService.class);
    }

    private void encodeContentBegin(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        writer.startElement("div", component);
        writer.writeAttribute("class", (Object)this.concatClasses("rf-tab-cnt", TabRenderer.attributeAsString(component, "contentClass")), null);
        writer.writeAttribute("id", (Object)(component.getClientId(context) + ":content"), null);
    }

    private void encodeContentEnd(UIComponent component, ResponseWriter responseWriter) throws IOException {
        responseWriter.endElement("div");
    }

    @Override
    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.Tab", component.getClientId(context), this.getScriptObjectOptions(context, component));
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        Map<String, Object> res = super.getScriptObjectOptions(context, component);
        res.put("disabled", ((AbstractTab)component).isDisabled());
        res.put("enter", ((AbstractTogglePanelItemInterface)component).getOnenter());
        res.put("leave", ((AbstractTogglePanelItemInterface)component).getOnleave());
        return res;
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractTab.class;
    }

    private static AbstractTabPanel getParentTabPanel(AbstractTab menuItem) {
        return (AbstractTabPanel)ComponentIterators.getParent((UIComponent)menuItem, new Predicate<UIComponent>(){

            public boolean apply(UIComponent component) {
                return component instanceof AbstractTabPanel;
            }
        });
    }
}

