/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.util;

import com.google.common.base.Strings;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.richfaces.JsfVersion;
import org.richfaces.ui.behavior.HandlersChain;
import org.richfaces.ui.common.AjaxFunction;
import org.richfaces.ui.common.AjaxOptions;
import org.richfaces.util.RendererUtils;

public final class AjaxRendererUtils {
    public static final String BEGIN_EVENT_NAME = "begin";
    public static final String AJAX_ABORT_ATTR = "ignoreDupResponses";
    public static final String AJAX_AREAS_RENDERED = "org.richfaces.areas.rendered";
    public static final String AJAX_DELAY_ATTR = "requestDelay";
    public static final String AJAX_QUEUE_ATTR = "eventsQueue";
    public static final String AJAX_SINGLE_ATTR = "ajaxSingle";
    public static final String AJAX_SINGLE_PARAMETER_NAME = "ajaxSingle";
    public static final String ONBEGIN_ATTR_NAME = "onbegin";
    public static final String ONCOMPLETE_CONTENT_ID = "org.richfaces.oncomplete";
    public static final String SIMILARITY_GROUPING_ID_ATTR = "similarityGroupingId";
    public static final String STATUS_ATTR_NAME = "status";
    public static final String VALUE_ATTR = "value";
    public static final String QUEUE_ID_ATTRIBUTE = "queueId";
    private static final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();
    private static final String VIEW_STATE_COUNTER_KEY = "org.richfaces.ViewStateCounterKey";
    private static final int VIEW_STATE_NUMBER_BASE = 0;

    private AjaxRendererUtils() {
    }

    public static AjaxOptions buildEventOptions(FacesContext facesContext, UIComponent component) {
        AjaxOptions ajaxOptions = new AjaxOptions();
        AjaxRendererUtils.appendComponentOptions(facesContext, component, ajaxOptions);
        Map<String, Object> parametersMap = RENDERER_UTILS.createParametersMap(facesContext, component);
        ajaxOptions.addParameters(parametersMap);
        return ajaxOptions;
    }

    private static String getHandlerScript(FacesContext facesContext, UIComponent component, String attributeName, String eventName) {
        HandlersChain handlersChain = new HandlersChain(facesContext, component);
        String inlineHandler = (String)component.getAttributes().get(attributeName);
        handlersChain.addInlineHandlerAsValue(inlineHandler);
        handlersChain.addBehaviors(eventName);
        return handlersChain.toScript();
    }

    private static void appendComponentOptions(FacesContext facesContext, UIComponent component, AjaxOptions ajaxOptions) {
        String queueId;
        String handlerScript = AjaxRendererUtils.getHandlerScript(facesContext, component, ONBEGIN_ATTR_NAME, BEGIN_EVENT_NAME);
        if (!Strings.isNullOrEmpty((String)handlerScript)) {
            ajaxOptions.set(BEGIN_EVENT_NAME, handlerScript);
        }
        if (!Strings.isNullOrEmpty((String)(queueId = AjaxRendererUtils.getQueueId(component)))) {
            ajaxOptions.set(QUEUE_ID_ATTRIBUTE, queueId);
        }
        ajaxOptions.set("incId", "1");
        String status = AjaxRendererUtils.getAjaxStatus(component);
        if (!Strings.isNullOrEmpty((String)status)) {
            ajaxOptions.set(STATUS_ATTR_NAME, status);
        }
    }

    public static AjaxFunction buildAjaxFunction(FacesContext facesContext, UIComponent component) {
        return new AjaxFunction(component.getClientId(facesContext), AjaxRendererUtils.buildEventOptions(facesContext, component));
    }

    public static String getAjaxStatus(UIComponent component) {
        return (String)component.getAttributes().get(STATUS_ATTR_NAME);
    }

    private static String getQueueId(UIComponent component) {
        return (String)component.getAttributes().get(QUEUE_ID_ATTRIBUTE);
    }

    public static String getViewStateId(FacesContext context) {
        if (JsfVersion.getCurrent().isCompliantWith(JsfVersion.JSF_2_2)) {
            return AjaxRendererUtils.generateUniqueViewStateId(context);
        }
        return "javax.faces.ViewState";
    }

    private static String generateUniqueViewStateId(FacesContext context) {
        String result = null;
        Map contextAttrs = context.getAttributes();
        Integer counter = (Integer)contextAttrs.get(VIEW_STATE_COUNTER_KEY);
        if (null == counter) {
            counter = 0;
        }
        char sep = UINamingContainer.getSeparatorChar((FacesContext)context);
        UIViewRoot root = context.getViewRoot();
        result = root.getContainerClientId(context) + sep + "javax.faces.ViewState" + sep + counter;
        counter = counter + 1;
        contextAttrs.put(VIEW_STATE_COUNTER_KEY, counter);
        return result;
    }
}

