/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.util;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.util.URLToStreamHelper;

public final class PropertiesUtil {
    private static final Logger LOGGER = RichfacesLogger.UTIL.getLogger();

    private PropertiesUtil() {
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = PropertiesUtil.class.getClassLoader();
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadProperties(Properties properties, String location) {
        boolean loaded;
        block8: {
            loaded = false;
            try {
                Enumeration<URL> resources = PropertiesUtil.getClassLoader().getResources(location);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    InputStream propertyStream = null;
                    try {
                        propertyStream = URLToStreamHelper.urlToStream(url);
                        properties.load(propertyStream);
                        loaded = true;
                    }
                    catch (IOException e) {
                        LOGGER.warn(MessageFormat.format("Failure loading properties from URL: {0}", url.toExternalForm()), e);
                    }
                    finally {
                        if (null == propertyStream) continue;
                        propertyStream.close();
                    }
                }
            }
            catch (IOException e) {
                if (!LOGGER.isInfoEnabled()) break block8;
                LOGGER.warn(MessageFormat.format("Failure loading properties from location: {0}", location), e);
            }
        }
        return loaded;
    }

    public static Map<String, String> loadProperties(String location) {
        Properties props = new Properties();
        PropertiesUtil.loadProperties(props, location);
        return Maps.fromProperties((Properties)props);
    }
}

