/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.ui.input.autocomplete;

import java.io.Serializable;
import javax.el.MethodExpression;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.ComponentConfig;
import org.richfaces.ui.input.autocomplete.UIAutocomplete;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;

public class AutocompleteHandler extends ComponentHandler {


    public AutocompleteHandler(ComponentConfig config) {
        super(config);
        
    }

    private static final MetaRule META_RULE = new MetaRule(){

        public Metadata applyRule(String name, final TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(UIAutocomplete.class)) {
                if ("autocompleteMethod".equals(name)) {
                    return new Metadata() {
                        private final Class<?>[] SIGNATURE={FacesContext.class,UIComponent.class,String.class};
                        public void applyMetadata(FaceletContext ctx, Object instance) {
                            ((UIAutocomplete) instance).setAutocompleteMethod(getValue(ctx));
                        }
                        private MethodExpression getValue(FaceletContext ctx){
                           return attribute.getMethodExpression(ctx, Object.class, SIGNATURE);
                        }
                    };
                }
                if ("validator".equals(name)) {
                    return new Metadata() {
                        private final Class<?>[] SIGNATURE={FacesContext.class,UIComponent.class,Object.class};
                        public void applyMetadata(FaceletContext ctx, Object instance) {
                            ((UIAutocomplete) instance).setValidator(getValue(ctx));
                        }
                        @SuppressWarnings("deprecation")
                        private MethodBinding getValue(FaceletContext ctx){
                           return new MethodBindingWrapper(attribute.getMethodExpression(ctx, Void.class, SIGNATURE));
                        }
                    };
                }
                if ("valueChangeListener".equals(name)) {
                    return new Metadata() {
                        private final Class<?>[] SIGNATURE={ValueChangeEvent.class};
                        public void applyMetadata(FaceletContext ctx, Object instance) {
                            ((UIAutocomplete) instance).setValueChangeListener(getValue(ctx));
                        }
                        @SuppressWarnings("deprecation")
                        private MethodBinding getValue(FaceletContext ctx){
                           return new MethodBindingWrapper(attribute.getMethodExpression(ctx, Void.class, SIGNATURE));
                        }
                    };
                }
            }
            return null;
        }
    };
    
    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset m = super.createMetaRuleset(type);
        m.addRule(META_RULE);
        return m;
    }

    @SuppressWarnings({ "serial", "deprecation" })
    public static final class MethodBindingWrapper extends
            MethodBinding implements Serializable {
    
        private final MethodExpression m;
    
        public MethodBindingWrapper(MethodExpression m) {
            this.m = m;
        }
    
        public Class getType(FacesContext context)
                throws MethodNotFoundException {
            try {
                return m.getMethodInfo(context.getELContext()).getReturnType();
            } catch (javax.el.MethodNotFoundException e) {
                throw new MethodNotFoundException(e.getMessage(), e.getCause());
            } catch (ELException e) {
                throw new EvaluationException(e.getMessage(), e.getCause());
            }
        }
    
        public Object invoke(FacesContext context, Object[] params)
                throws EvaluationException, MethodNotFoundException {
            try {
                return m.invoke(context.getELContext(), params);
            } catch (javax.el.MethodNotFoundException e) {
                throw new MethodNotFoundException(e.getMessage(), e.getCause());
            } catch (ELException e) {
                throw new EvaluationException(e.getMessage(), e.getCause());
            }
        }
    
        public String getExpressionString() {
            return m.getExpressionString();
        }
    }
}
