package org.richfaces.ui.input.autocomplete;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.javascript.JSReference;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;
import org.richfaces.ui.input.autocomplete.AbstractAutocomplete;
import org.richfaces.ui.input.autocomplete.AutocompleteRendererBase;


@ResourceDependencies({@ResourceDependency(name="bootstrap.css",library="bootstrap",target=""),@ResourceDependency(name="font-awesome.css",library="font-awesome",target=""),@ResourceDependency(name="input/autocomplete.css",library="io.richwidgets",target=""),@ResourceDependency(name="jsf.js",library="javax.faces",target=""),@ResourceDependency(name="jquery.js",library="org.richfaces",target=""),@ResourceDependency(name="richfaces.js",library="org.richfaces",target=""),@ResourceDependency(name="richfaces-queue.reslib",library="org.richfaces",target=""),@ResourceDependency(name="jquery.ui.core.js",library="com.jqueryui",target=""),@ResourceDependency(name="jquery.ui.widget.js",library="com.jqueryui",target=""),@ResourceDependency(name="jquery.ui.position.js",library="com.jqueryui",target=""),@ResourceDependency(name="jquery.ui.menu.js",library="com.jqueryui",target=""),@ResourceDependency(name="jquery.ui.autocomplete.js",library="com.jqueryui",target=""),@ResourceDependency(name="input/autocomplete.js",library="io.richwidgets",target=""),@ResourceDependency(name="bridge/bridge-base.js",library="org.richfaces",target=""),@ResourceDependency(name="bridge/input/autocomplete-bridge.js",library="org.richfaces",target="")})
public class AutocompleteRenderer extends AutocompleteRendererBase {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES1 = attributes()
	     .generic("accept","accept")
	     

	     .generic("accesskey","accesskey")
	     

	     .generic("align","align")
	     

	     .generic("alt","alt")
	     

	     .bool("checked","checked")
	     

	     .generic("dir","dir")
	     

	     .generic("lang","lang")
	     

	     .generic("maxlength","maxlength")
	     

	     .generic("onblur","onblur","blur")
	     

	     .generic("onclick","onclick","click")
	     

	     .generic("ondblclick","ondblclick","dblclick")
	     

	     .generic("onkeydown","onkeydown","onkeydown")
	     

	     .generic("onkeypress","onkeypress","onkeypress")
	     

	     .generic("onkeyup","onkeyup","onkeyup")
	     

	     .generic("onmousedown","onmousedown","mousedown")
	     

	     .generic("onmousemove","onmousemove","mousemove")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     

	     .generic("onmouseover","onmouseover","mouseover")
	     

	     .generic("onmouseup","onmouseup","mouseup")
	     

	     .generic("onselect","onselect","select")
	     

	     .bool("readonly","readonly")
	     

	     .generic("role","role")
	     

	     .generic("size","size")
	     

	     .uri("src","src")
	     

	     .generic("style","style")
	     

	     .generic("tabindex","tabindex")
	     

	     .generic("title","title")
	     

	     .uri("usemap","usemap")
	     
;
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH1 = attributes()
	     .generic("token","tokens")
	     

	     .generic("mode","mode")
	     .defaultValue(AutocompleteMode.cachedAjax)

	     .generic("showButton","showButton")
	     .defaultValue(false)

	     .generic("minLength","minChars")
	     .defaultValue(1)

	     .generic("autoFocus","selectFirst")
	     .defaultValue(true)
;
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH2 = attributes()
	     .generic("select","onselectitem","selectitem")
	     

	     .generic("select","onselect","select")
	     

	     .generic("change","onchange","change")
	     

	     .generic("close","onclose","close")
	     

	     .generic("focus","onfocus","focus")
	     

	     .generic("open","onopen","open")
	     

	     .generic("response","onresponse","response")
	     

	     .generic("search","onsearch","search")
	     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean isEmpty(Object object) 
 {
		if (object == null) {
		    return true;
		} else if (object.getClass().isArray()) {
		    return ((Object[]) object).length == 0;
		} else if (object instanceof java.util.Collection) {
		    return ((java.util.Collection<?>) object).isEmpty();
		} else if (object instanceof java.util.Map) {
		    return ((java.util.Map<?, ?>) object).isEmpty();
		} else {
			return object.toString().length() == 0;
		}
	}
	
public void renderSuggestionsAsList(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, Iterable items) 
		throws IOException
	 {
		AbstractAutocomplete component = (AbstractAutocomplete) uiComponent;
String clientId = component.getClientId(facesContext);
responseWriter.startElement("ul", component); 
   {
      String value = convertToString(clientId) + "Suggestions";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

  responseWriter.writeAttribute("style","display: none",null);


Object savedVar = saveVar(facesContext, component.getVar());
		for (Object item : items) {
			setVar(facesContext, component.getVar(), item);
			responseWriter.startElement("li", component); 
			   {
      Object value = component.getFetchValue();
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("data-label",value,null);
      }
      
   }


				if (isEmpty(component.getChildren())) {
	{
	Object text = item;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	} else  { 
			for (UIComponent c : component.getChildren()) {
			c.encodeAll(facesContext);
		}

}
			responseWriter.endElement("li"); 
		}

setVar(facesContext, component.getVar(), savedVar);
responseWriter.endElement("ul"); 

	}
	
public void renderSuggestionsAsTable(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, Iterable items) 
		throws IOException
	 {
		AbstractAutocomplete component = (AbstractAutocomplete) uiComponent;
String clientId = component.getClientId(facesContext);
responseWriter.startElement("table", component); 
   {
      String value = convertToString(clientId) + "Suggestions";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

  responseWriter.writeAttribute("style","display: none",null);


responseWriter.startElement("tbody", component); 

Object savedVar = saveVar(facesContext, component.getVar());
		for (Object item : items) {
			setVar(facesContext, component.getVar(), item);
			responseWriter.startElement("tr", component); 
			   {
      Object value = component.getFetchValue();
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("data-label",value,null);
      }
      
   }


					for (UIComponent column : component.getChildren()) {
			responseWriter.startElement("td", component); 
			
			column.encodeAll(facesContext);
			responseWriter.endElement("td"); 
		}

			responseWriter.endElement("tr"); 
		}

setVar(facesContext, component.getVar(), savedVar);
responseWriter.endElement("tbody"); 
responseWriter.endElement("table"); 

	}
	
private static boolean isEqual(Object o1, Object o2) 
 {
		if (o1 != null) {
	return o1.equals(o2);
} else {
	//o1 == null
	return o2 == null;
}
	}
	
public void renderSuggestions(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) 
		throws IOException
	 {
		AbstractAutocomplete component = (AbstractAutocomplete) uiComponent;
String clientId = component.getClientId(facesContext);
	if (isEqual(component.getLayout(),"list")) {
	renderSuggestionsAsList(responseWriter, facesContext, component, this.getSuggestionsAsDataModel(facesContext,component));
	} else if (isEqual(component.getLayout(),"table"))  { 
	renderSuggestionsAsTable(responseWriter, facesContext, component, this.getSuggestionsAsDataModel(facesContext,component));
}

	}
	
@Override
public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) 
		throws IOException
	 {
		AbstractAutocomplete component = (AbstractAutocomplete) uiComponent;
String clientId = component.getClientId(facesContext);
responseWriter.startElement("div", component); 
   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


responseWriter.startElement("input", component); 
   {
      Object value = this.concatClasses("form-control",component.getAttributes().get("styleClass"));
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

      if(component.isDisabled()) {
        responseWriter.writeAttribute("disabled","disabled",null);
      }

   {
      String value = convertToString(clientId) + "Input";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + "Input";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("name",value,null);
      }
      
   }

  responseWriter.writeAttribute("type","text",null);

   {
      String value = this.getInputValue(facesContext,component);
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("value",value,null);
      }
      
   }


	
renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES1);

responseWriter.endElement("input"); 
renderSuggestions(responseWriter, facesContext, component);
responseWriter.startElement("script", component); 

Map<String, Object> options = new LinkedHashMap<String, Object>(); 

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH1, null);

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH2, ScriptHashVariableWrapper.eventHandler);
addToScriptHash(options, "filter", this.getClientFilterFunction(component), null, null);


{
	Object text = "RichFaces.jQuery(document.getElementById('" + convertToString(clientId) + "')).autocompleteBridge(" + convertToString(toScriptArgs(options)) + ");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("script"); 
responseWriter.endElement("div"); 

	}
}

