/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.ui.input.autocomplete;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.ui.input.autocomplete.AbstractAutocomplete;
import javax.el.MethodExpression;
import org.richfaces.ui.attribute.AjaxEventsProps;
import org.richfaces.ui.attribute.EventsKeyProps;
import org.richfaces.ui.attribute.EventsMouseProps;
import org.richfaces.ui.attribute.FocusProps;
import org.richfaces.ui.attribute.StyleClassProps;
import org.richfaces.ui.attribute.StyleProps;
import org.richfaces.ui.common.meta.MetaComponentEncoder;
import org.richfaces.ui.common.meta.MetaComponentResolver;

/**
 *  <p>
 The &lt;r:autocomplete&gt; component is an auto-completing input-box with built-in Ajax capabilities. It supports client-side
 suggestions, browser-like selection, and customization of the look and feel.
 </p>

 @author Lukas Fryc

 **/
@Generated({"RichFaces CDK", "4.5.0-SNAPSHOT"})
public class UIAutocomplete extends AbstractAutocomplete
    implements ClientBehaviorHolder,AjaxEventsProps,EventsKeyProps,EventsMouseProps,FocusProps,StyleClassProps,StyleProps,MetaComponentEncoder,MetaComponentResolver    {

    public static final String COMPONENT_TYPE="org.richfaces.ui.Autocomplete";

    public static final String COMPONENT_FAMILY="javax.faces.Input";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIAutocomplete() {
        super();
        setRendererType("org.richfaces.ui.AutocompleteRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "mousedown",
        "click",
        "blur",
        "mouseover",
        "begin",
        "mousemove",
        "error",
        "mouseout",
        "onkeydown",
        "onkeypress",
        "onkeyup",
        "open",
        "beforedomupdate",
        "selectitem",
        "complete",
        "dblclick",
        "response",
        "focus",
        "close",
        "select",
        "search",
        "mouseup",
        "change"
        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return "change";
    }


    protected enum Properties {
        autocompleteList,
        autocompleteMethod,
        autofill,
        clientFilterFunction,
        disabled,
        fetchValue,
        minChars,
        mode,
        onbeforedomupdate,
        onbegin,
        onblur,
        onchange,
        onclick,
        onclose,
        oncomplete,
        ondblclick,
        onerror,
        onfocus,
        onkeydown,
        onkeypress,
        onkeyup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        onopen,
        onresponse,
        onsearch,
        onselect,
        onselectitem,
        selectFirst,
        showButton,
        style,
        styleClass,
        tabindex,
        tokens,
        var
        
    }

 
    public Object getAutocompleteList() {
        Object value = (Object) getStateHelper().eval(Properties.autocompleteList);
        return value;
    }
    
    public void setAutocompleteList(Object autocompleteList) {
        getStateHelper().put(Properties.autocompleteList, autocompleteList);
    }

 
    public MethodExpression getAutocompleteMethod() {
        MethodExpression value = (MethodExpression) getStateHelper().get(Properties.autocompleteMethod);
        return value;
    }
    
    public void setAutocompleteMethod(MethodExpression autocompleteMethod) {
        getStateHelper().put(Properties.autocompleteMethod, autocompleteMethod);
    }

 
    public boolean isAutofill() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.autofill, true);
        return value;
    }
    
    public void setAutofill(boolean autofill) {
        getStateHelper().put(Properties.autofill, autofill);
    }

 
    public String getClientFilterFunction() {
        String value = (String) getStateHelper().eval(Properties.clientFilterFunction);
        return value;
    }
    
    public void setClientFilterFunction(String clientFilterFunction) {
        getStateHelper().put(Properties.clientFilterFunction, clientFilterFunction);
    }

 
    public boolean isDisabled() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.disabled, false);
        return value;
    }
    
    public void setDisabled(boolean disabled) {
        getStateHelper().put(Properties.disabled, disabled);
    }

 
    public Object getFetchValue() {
        Object value = (Object) getStateHelper().eval(Properties.fetchValue);
        return value;
    }
    
    public void setFetchValue(Object fetchValue) {
        getStateHelper().put(Properties.fetchValue, fetchValue);
    }

 
    public int getMinChars() {
        Integer value = (Integer) getStateHelper().eval(Properties.minChars, 1);
        return value;
    }
    
    public void setMinChars(int minChars) {
        getStateHelper().put(Properties.minChars, minChars);
    }

 
    public AutocompleteMode getMode() {
        AutocompleteMode value = (AutocompleteMode) getStateHelper().eval(Properties.mode, AutocompleteMode.cachedAjax);
        return value;
    }
    
    public void setMode(AutocompleteMode mode) {
        getStateHelper().put(Properties.mode, mode);
    }

 
    public String getOnbeforedomupdate() {
        String value = (String) getStateHelper().eval(Properties.onbeforedomupdate);
        return value;
    }
    
    public void setOnbeforedomupdate(String onbeforedomupdate) {
        getStateHelper().put(Properties.onbeforedomupdate, onbeforedomupdate);
    }

 
    public String getOnbegin() {
        String value = (String) getStateHelper().eval(Properties.onbegin);
        return value;
    }
    
    public void setOnbegin(String onbegin) {
        getStateHelper().put(Properties.onbegin, onbegin);
    }

 
    public String getOnblur() {
        String value = (String) getStateHelper().eval(Properties.onblur);
        return value;
    }
    
    public void setOnblur(String onblur) {
        getStateHelper().put(Properties.onblur, onblur);
        handleAttribute("onblur",onblur);
    }

 
    public String getOnchange() {
        String value = (String) getStateHelper().eval(Properties.onchange);
        return value;
    }
    
    public void setOnchange(String onchange) {
        getStateHelper().put(Properties.onchange, onchange);
    }

 
    public String getOnclick() {
        String value = (String) getStateHelper().eval(Properties.onclick);
        return value;
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
        handleAttribute("onclick",onclick);
    }

 
    public String getOnclose() {
        String value = (String) getStateHelper().eval(Properties.onclose);
        return value;
    }
    
    public void setOnclose(String onclose) {
        getStateHelper().put(Properties.onclose, onclose);
    }

 
    public String getOncomplete() {
        String value = (String) getStateHelper().eval(Properties.oncomplete);
        return value;
    }
    
    public void setOncomplete(String oncomplete) {
        getStateHelper().put(Properties.oncomplete, oncomplete);
    }

 
    public String getOndblclick() {
        String value = (String) getStateHelper().eval(Properties.ondblclick);
        return value;
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
        handleAttribute("ondblclick",ondblclick);
    }

 
    public String getOnerror() {
        String value = (String) getStateHelper().eval(Properties.onerror);
        return value;
    }
    
    public void setOnerror(String onerror) {
        getStateHelper().put(Properties.onerror, onerror);
    }

 
    public String getOnfocus() {
        String value = (String) getStateHelper().eval(Properties.onfocus);
        return value;
    }
    
    public void setOnfocus(String onfocus) {
        getStateHelper().put(Properties.onfocus, onfocus);
        handleAttribute("onfocus",onfocus);
    }

 
    public String getOnkeydown() {
        String value = (String) getStateHelper().eval(Properties.onkeydown);
        return value;
    }
    
    public void setOnkeydown(String onkeydown) {
        getStateHelper().put(Properties.onkeydown, onkeydown);
        handleAttribute("onkeydown",onkeydown);
    }

 
    public String getOnkeypress() {
        String value = (String) getStateHelper().eval(Properties.onkeypress);
        return value;
    }
    
    public void setOnkeypress(String onkeypress) {
        getStateHelper().put(Properties.onkeypress, onkeypress);
        handleAttribute("onkeypress",onkeypress);
    }

 
    public String getOnkeyup() {
        String value = (String) getStateHelper().eval(Properties.onkeyup);
        return value;
    }
    
    public void setOnkeyup(String onkeyup) {
        getStateHelper().put(Properties.onkeyup, onkeyup);
        handleAttribute("onkeyup",onkeyup);
    }

 
    public String getOnmousedown() {
        String value = (String) getStateHelper().eval(Properties.onmousedown);
        return value;
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
        handleAttribute("onmousedown",onmousedown);
    }

 
    public String getOnmousemove() {
        String value = (String) getStateHelper().eval(Properties.onmousemove);
        return value;
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
        handleAttribute("onmousemove",onmousemove);
    }

 
    public String getOnmouseout() {
        String value = (String) getStateHelper().eval(Properties.onmouseout);
        return value;
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
        handleAttribute("onmouseout",onmouseout);
    }

 
    public String getOnmouseover() {
        String value = (String) getStateHelper().eval(Properties.onmouseover);
        return value;
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
        handleAttribute("onmouseover",onmouseover);
    }

 
    public String getOnmouseup() {
        String value = (String) getStateHelper().eval(Properties.onmouseup);
        return value;
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
        handleAttribute("onmouseup",onmouseup);
    }

 
    public String getOnopen() {
        String value = (String) getStateHelper().eval(Properties.onopen);
        return value;
    }
    
    public void setOnopen(String onopen) {
        getStateHelper().put(Properties.onopen, onopen);
    }

 
    public String getOnresponse() {
        String value = (String) getStateHelper().eval(Properties.onresponse);
        return value;
    }
    
    public void setOnresponse(String onresponse) {
        getStateHelper().put(Properties.onresponse, onresponse);
    }

 
    public String getOnsearch() {
        String value = (String) getStateHelper().eval(Properties.onsearch);
        return value;
    }
    
    public void setOnsearch(String onsearch) {
        getStateHelper().put(Properties.onsearch, onsearch);
    }

 
    public String getOnselect() {
        String value = (String) getStateHelper().eval(Properties.onselect);
        return value;
    }
    
    public void setOnselect(String onselect) {
        getStateHelper().put(Properties.onselect, onselect);
    }

 
    public String getOnselectitem() {
        String value = (String) getStateHelper().eval(Properties.onselectitem);
        return value;
    }
    
    public void setOnselectitem(String onselectitem) {
        getStateHelper().put(Properties.onselectitem, onselectitem);
    }

 
    public boolean isSelectFirst() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.selectFirst, true);
        return value;
    }
    
    public void setSelectFirst(boolean selectFirst) {
        getStateHelper().put(Properties.selectFirst, selectFirst);
    }

 
    public boolean isShowButton() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.showButton, false);
        return value;
    }
    
    public void setShowButton(boolean showButton) {
        getStateHelper().put(Properties.showButton, showButton);
    }

 
    public String getStyle() {
        String value = (String) getStateHelper().eval(Properties.style);
        return value;
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
        handleAttribute("style",style);
    }

 
    public String getStyleClass() {
        String value = (String) getStateHelper().eval(Properties.styleClass);
        return value;
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
        handleAttribute("styleClass",styleClass);
    }

 
    public String getTabindex() {
        String value = (String) getStateHelper().eval(Properties.tabindex);
        return value;
    }
    
    public void setTabindex(String tabindex) {
        getStateHelper().put(Properties.tabindex, tabindex);
        handleAttribute("tabindex",tabindex);
    }

 
    public String getTokens() {
        String value = (String) getStateHelper().eval(Properties.tokens);
        return value;
    }
    
    public void setTokens(String tokens) {
        getStateHelper().put(Properties.tokens, tokens);
    }

 
    public String getVar() {
        String value = (String) getStateHelper().get(Properties.var);
        return value;
    }
    
    public void setVar(String var) {
        getStateHelper().put(Properties.var, var);
    }
    private static final String ATTRIBUTES_THAT_ARE_SET_KEY = "javax.faces.component.UIComponentBase.attributesThatAreSet";
    
    private void handleAttribute(String name, Object value) {
        List<String> setAttributes = (List<String>) this.getAttributes().get(ATTRIBUTES_THAT_ARE_SET_KEY);
        if (setAttributes == null) {
                setAttributes = new ArrayList<String>(15);
                this.getAttributes().put(ATTRIBUTES_THAT_ARE_SET_KEY, setAttributes);
        }
        if (value == null) {
                ValueExpression ve = getValueExpression(name);
                if (ve == null) {
                    setAttributes.remove(name);
                }
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
        }
    }    

    

}