package org.richfaces.ui.message.notifyMessage;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;
import org.richfaces.ui.message.NotifyMessageRendererBase;
import static org.richfaces.ui.message.NotifyRendererUtils.addStackIdOption;


@ResourceDependencies({@ResourceDependency(name="jsf.js",library="javax.faces",target=""),@ResourceDependency(name="jquery.js",library="org.richfaces",target=""),@ResourceDependency(name="richfaces.js",library="org.richfaces",target=""),@ResourceDependency(name="common/richfaces-base-component.js",library="org.richfaces",target=""),@ResourceDependency(name="richfaces-event.js",library="org.richfaces",target=""),@ResourceDependency(name="message/notify/notifyMessage.js",library="org.richfaces",target=""),@ResourceDependency(name="jquery.pnotify.js",library="jquery.plugins",target=""),@ResourceDependency(name="message/notify/notify.js",library="org.richfaces",target=""),@ResourceDependency(name="message/notify/notifyStack.js",library="org.richfaces",target=""),@ResourceDependency(name="message/notify/notify.ecss",library="org.richfaces",target="")})
public class HtmlNotifyMessageRenderer extends NotifyMessageRendererBase {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES25 = attributes()
	     .generic("dir","dir")
	     

	     .generic("lang","lang")
	     

	     .generic("onclick","onclick","click")
	     

	     .generic("ondblclick","ondblclick","dblclick")
	     

	     .generic("onkeydown","onkeydown","onkeydown")
	     

	     .generic("onkeypress","onkeypress","onkeypress")
	     

	     .generic("onkeyup","onkeyup","onkeyup")
	     

	     .generic("onmousedown","onmousedown","mousedown")
	     

	     .generic("onmousemove","onmousemove","mousemove")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     

	     .generic("onmouseover","onmouseover","mouseover")
	     

	     .generic("onmouseup","onmouseup","mouseup")
	     

	     .generic("role","role")
	     

	     .generic("style","style")
	     

	     .generic("title","title")
	     
;
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH28 = attributes()
	     .generic("sticky","sticky")
	     .defaultValue(false)

	     .generic("stayTime","stayTime")
	     

	     .generic("delay","delay")
	     

	     .generic("styleClass","styleClass")
	     

	     .generic("appearAnimation","appearAnimation")
	     

	     .generic("hideAnimation","hideAnimation")
	     

	     .generic("animationSpeed","animationSpeed")
	     

	     .generic("showHistory","showHistory")
	     

	     .generic("nonblocking","nonblocking")
	     .defaultValue(false)

	     .generic("showShadow","showShadow")
	     .defaultValue(false)

	     .generic("showCloseButton","showCloseButton")
	     .defaultValue(true)

	     .generic("nonblockingOpacity","nonblockingOpacity")
	     
;
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH29 = attributes()
	     .generic("onclick","onclick","click")
	     

	     .generic("ondblclick","ondblclick","dblclick")
	     

	     .generic("onkeydown","onkeydown","onkeydown")
	     

	     .generic("onkeypress","onkeypress","onkeypress")
	     

	     .generic("onkeyup","onkeyup","onkeyup")
	     

	     .generic("onmousedown","onmousedown","mousedown")
	     

	     .generic("onmousemove","onmousemove","mousemove")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     

	     .generic("onmouseover","onmouseover","mouseover")
	     

	     .generic("onmouseup","onmouseup","mouseup")
	     
;
	
	
@Override
public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		String clientId = component.getClientId(facesContext);
responseWriter.startElement("span", component); 
  responseWriter.writeAttribute("class","rf-ntf-msg",null);

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	
renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES25);

Map<String, Object> options = new LinkedHashMap<String, Object>(); 

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH28, null);

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH29, ScriptHashVariableWrapper.eventHandler);

addStackIdOption(options, facesContext, component);
encodeScript(facesContext,component, options);
encodeNotification(facesContext, component, options);
responseWriter.endElement("span"); 

	}
}

