package org.richfaces.ui.output.chart;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;
import org.richfaces.ui.output.chart.AbstractChart;
import org.richfaces.ui.output.chart.ChartRendererBase;


@ResourceDependencies({@ResourceDependency(name="jsf.js",library="javax.faces",target=""),@ResourceDependency(name="jquery.js",library="org.richfaces",target=""),@ResourceDependency(name="richfaces.js",library="org.richfaces",target=""),@ResourceDependency(name="richfaces-queue.reslib",library="org.richfaces",target=""),@ResourceDependency(name="jquery.ui.core.js",library="com.jqueryui",target=""),@ResourceDependency(name="jquery.ui.widget.js",library="com.jqueryui",target=""),@ResourceDependency(name="jquery.flot.js",library="flot",target=""),@ResourceDependency(name="jquery.flot.categories.js",library="flot",target=""),@ResourceDependency(name="jquery.flot.pie.js",library="flot",target=""),@ResourceDependency(name="jquery.flot.time.js",library="flot",target=""),@ResourceDependency(name="jquery.flot.axislabels.js",library="flot",target=""),@ResourceDependency(name="jquery.flot.symbol.js",library="flot",target=""),@ResourceDependency(name="jquery.flot.orderBars.js",library="flot",target=""),@ResourceDependency(name="jquery.flot.tooltip.js",library="flot",target=""),@ResourceDependency(name="jquery.flot.selection.js",library="flot",target=""),@ResourceDependency(name="jquery.flot.resize.js",library="flot",target=""),@ResourceDependency(name="output/chart.js",library="io.richwidgets",target=""),@ResourceDependency(name="output/chart.css",library="io.richwidgets",target=""),@ResourceDependency(name="bridge/bridge-base.js",library="org.richfaces",target=""),@ResourceDependency(name="bridge/output/chart-bridge.js",library="org.richfaces",target="")})
public class ChartRenderer extends ChartRendererBase {
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH23 = attributes()
	     .generic("onplotclick","onplotclick","plotclick")
	     

	     .generic("onplothover","onplothover","plothover")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
@Override
public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) 
		throws IOException
	 {
		AbstractChart component = (AbstractChart) uiComponent;
String clientId = component.getClientId(facesContext);
Map<String, Object> events = new LinkedHashMap<String, Object>(); 

	
addToScriptHash(events, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH23, ScriptHashVariableWrapper.eventHandler);

responseWriter.startElement("div", component); 
   {
      String value = convertToString(component.getStyleClass()) + " chart-container";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","chart-title",null);


{
	Object text = component.getTitle();
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("div"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","chart",null);

   {
      String value = convertToString(clientId) + "Chart";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


responseWriter.endElement("div"); 
responseWriter.startElement("script", component); 
  responseWriter.writeAttribute("type","text/javascript",null);


{
	Object text = "//\n\t                    RichFaces.jQuery(document.getElementById(\"" + convertToString(clientId) + "\")).chartBridge(\n\t                                   RichFaces.jQuery.extend({\n\t\t                                    handlers: RichFaces.jQuery.extend(" + convertToString(toScriptArgs(events)) + "),\n\t\t                                    particularSeriesHandlers: " + convertToString(this.getParticularSeriesHandler(facesContext,component)) + ",\n\t\t                                    data: " + convertToString(this.getChartData(facesContext,component)) + ",\n\t                                    },\n\t                                    " + convertToString(this.getOpts(facesContext,component)) + "\n\t                                   )\n\t                      );\n\t            //";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("script"); 
responseWriter.endElement("div"); 

	}
}

