/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.ui.select.orderingList;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.ui.select.orderingList.AbstractOrderingList;
import org.richfaces.ui.attribute.EventsKeyProps;
import org.richfaces.ui.attribute.EventsMouseProps;
import org.richfaces.ui.attribute.MultiSelectProps;
import org.richfaces.ui.select.SelectItemsInterface;

/**
 *  <p>The &lt;r:orderingList&gt; is a component for ordering items in a list (client-side).</p>

 @author <a href="http://community.jboss.org/people/bleathem">Brian Leathem</a>

 **/
@Generated({"RichFaces CDK", "4.5.0-SNAPSHOT"})
public class UIOrderingList extends AbstractOrderingList
    implements ClientBehaviorHolder,EventsKeyProps,EventsMouseProps,MultiSelectProps,SelectItemsInterface    {

    public static final String COMPONENT_TYPE="org.richfaces.select.OrderingList";

    public static final String COMPONENT_FAMILY="org.richfaces.SelectMany";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIOrderingList() {
        super();
        setRendererType("org.richfaces.select.OrderingListRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "mousedown",
        "click",
        "blur",
        "mouseover",
        "mousemove",
        "onkeydown",
        "mouseout",
        "onkeypress",
        "onkeyup",
        "dblclick",
        "focus",
        "mouseup",
        "change"
        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return "change";
    }


    protected enum Properties {
        caption,
        collectionType,
        columnClasses,
        disabled,
        downBottomText,
        downText,
        itemLabel,
        itemValue,
        listHeight,
        maxListHeight,
        minListHeight,
        onblur,
        onchange,
        onclick,
        ondblclick,
        onfocus,
        onkeydown,
        onkeypress,
        onkeyup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        showButton,
        style,
        styleClass,
        upText,
        upTopText,
        var
        
    }

 
    public String getCaption() {
        String value = (String) getStateHelper().eval(Properties.caption);
        return value;
    }
    
    public void setCaption(String caption) {
        getStateHelper().put(Properties.caption, caption);
    }

 
    public String getCollectionType() {
        String value = (String) getStateHelper().eval(Properties.collectionType);
        return value;
    }
    
    public void setCollectionType(String collectionType) {
        getStateHelper().put(Properties.collectionType, collectionType);
    }

 
    public String getColumnClasses() {
        String value = (String) getStateHelper().eval(Properties.columnClasses);
        return value;
    }
    
    public void setColumnClasses(String columnClasses) {
        getStateHelper().put(Properties.columnClasses, columnClasses);
    }

 
    public boolean isDisabled() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.disabled, false);
        return value;
    }
    
    public void setDisabled(boolean disabled) {
        getStateHelper().put(Properties.disabled, disabled);
    }

 
    public String getDownBottomText() {
        String value = (String) getStateHelper().eval(Properties.downBottomText);
        return value;
    }
    
    public void setDownBottomText(String downBottomText) {
        getStateHelper().put(Properties.downBottomText, downBottomText);
    }

 
    public String getDownText() {
        String value = (String) getStateHelper().eval(Properties.downText);
        return value;
    }
    
    public void setDownText(String downText) {
        getStateHelper().put(Properties.downText, downText);
    }

 
    public Object getItemLabel() {
        Object value = (Object) getStateHelper().eval(Properties.itemLabel);
        return value;
    }
    
    public void setItemLabel(Object itemLabel) {
        getStateHelper().put(Properties.itemLabel, itemLabel);
    }

 
    public Object getItemValue() {
        Object value = (Object) getStateHelper().eval(Properties.itemValue);
        return value;
    }
    
    public void setItemValue(Object itemValue) {
        getStateHelper().put(Properties.itemValue, itemValue);
    }

 
    public String getListHeight() {
        String value = (String) getStateHelper().eval(Properties.listHeight);
        return value;
    }
    
    public void setListHeight(String listHeight) {
        getStateHelper().put(Properties.listHeight, listHeight);
    }

 
    public String getMaxListHeight() {
        String value = (String) getStateHelper().eval(Properties.maxListHeight);
        return value;
    }
    
    public void setMaxListHeight(String maxListHeight) {
        getStateHelper().put(Properties.maxListHeight, maxListHeight);
    }

 
    public String getMinListHeight() {
        String value = (String) getStateHelper().eval(Properties.minListHeight);
        return value;
    }
    
    public void setMinListHeight(String minListHeight) {
        getStateHelper().put(Properties.minListHeight, minListHeight);
    }

 
    public String getOnblur() {
        String value = (String) getStateHelper().eval(Properties.onblur);
        return value;
    }
    
    public void setOnblur(String onblur) {
        getStateHelper().put(Properties.onblur, onblur);
    }

 
    public String getOnchange() {
        String value = (String) getStateHelper().eval(Properties.onchange);
        return value;
    }
    
    public void setOnchange(String onchange) {
        getStateHelper().put(Properties.onchange, onchange);
    }

 
    public String getOnclick() {
        String value = (String) getStateHelper().eval(Properties.onclick);
        return value;
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
        handleAttribute("onclick",onclick);
    }

 
    public String getOndblclick() {
        String value = (String) getStateHelper().eval(Properties.ondblclick);
        return value;
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
        handleAttribute("ondblclick",ondblclick);
    }

 
    public String getOnfocus() {
        String value = (String) getStateHelper().eval(Properties.onfocus);
        return value;
    }
    
    public void setOnfocus(String onfocus) {
        getStateHelper().put(Properties.onfocus, onfocus);
    }

 
    public String getOnkeydown() {
        String value = (String) getStateHelper().eval(Properties.onkeydown);
        return value;
    }
    
    public void setOnkeydown(String onkeydown) {
        getStateHelper().put(Properties.onkeydown, onkeydown);
        handleAttribute("onkeydown",onkeydown);
    }

 
    public String getOnkeypress() {
        String value = (String) getStateHelper().eval(Properties.onkeypress);
        return value;
    }
    
    public void setOnkeypress(String onkeypress) {
        getStateHelper().put(Properties.onkeypress, onkeypress);
        handleAttribute("onkeypress",onkeypress);
    }

 
    public String getOnkeyup() {
        String value = (String) getStateHelper().eval(Properties.onkeyup);
        return value;
    }
    
    public void setOnkeyup(String onkeyup) {
        getStateHelper().put(Properties.onkeyup, onkeyup);
        handleAttribute("onkeyup",onkeyup);
    }

 
    public String getOnmousedown() {
        String value = (String) getStateHelper().eval(Properties.onmousedown);
        return value;
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
        handleAttribute("onmousedown",onmousedown);
    }

 
    public String getOnmousemove() {
        String value = (String) getStateHelper().eval(Properties.onmousemove);
        return value;
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
        handleAttribute("onmousemove",onmousemove);
    }

 
    public String getOnmouseout() {
        String value = (String) getStateHelper().eval(Properties.onmouseout);
        return value;
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
        handleAttribute("onmouseout",onmouseout);
    }

 
    public String getOnmouseover() {
        String value = (String) getStateHelper().eval(Properties.onmouseover);
        return value;
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
        handleAttribute("onmouseover",onmouseover);
    }

 
    public String getOnmouseup() {
        String value = (String) getStateHelper().eval(Properties.onmouseup);
        return value;
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
        handleAttribute("onmouseup",onmouseup);
    }

 
    public boolean isShowButton() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.showButton, true);
        return value;
    }
    
    public void setShowButton(boolean showButton) {
        getStateHelper().put(Properties.showButton, showButton);
    }

 
    public String getStyle() {
        String value = (String) getStateHelper().eval(Properties.style);
        return value;
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
        handleAttribute("style",style);
    }

 
    public String getStyleClass() {
        String value = (String) getStateHelper().eval(Properties.styleClass);
        return value;
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
        handleAttribute("styleClass",styleClass);
    }

 
    public String getUpText() {
        String value = (String) getStateHelper().eval(Properties.upText);
        return value;
    }
    
    public void setUpText(String upText) {
        getStateHelper().put(Properties.upText, upText);
    }

 
    public String getUpTopText() {
        String value = (String) getStateHelper().eval(Properties.upTopText);
        return value;
    }
    
    public void setUpTopText(String upTopText) {
        getStateHelper().put(Properties.upTopText, upTopText);
    }

 
    public String getVar() {
        String value = (String) getStateHelper().eval(Properties.var);
        return value;
    }
    
    public void setVar(String var) {
        getStateHelper().put(Properties.var, var);
    }
    private static final String ATTRIBUTES_THAT_ARE_SET_KEY = "javax.faces.component.UIComponentBase.attributesThatAreSet";
    
    private void handleAttribute(String name, Object value) {
        List<String> setAttributes = (List<String>) this.getAttributes().get(ATTRIBUTES_THAT_ARE_SET_KEY);
        if (setAttributes == null) {
                setAttributes = new ArrayList<String>(12);
                this.getAttributes().put(ATTRIBUTES_THAT_ARE_SET_KEY, setAttributes);
        }
        if (value == null) {
                ValueExpression ve = getValueExpression(name);
                if (ve == null) {
                    setAttributes.remove(name);
                }
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
        }
    }    

    

}