package org.richfaces.ui.select.pickList;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;
import org.richfaces.ui.common.ForEachLoop;
import org.richfaces.ui.select.ClientSelectItem;
import org.richfaces.ui.select.pickList.AbstractPickList;
import org.richfaces.ui.select.pickList.PickListRendererBase;


@ResourceDependencies({@ResourceDependency(name="bootstrap.css",library="bootstrap",target=""),@ResourceDependency(name="font-awesome.css",library="font-awesome",target=""),@ResourceDependency(name="select/select-list.css",library="io.richwidgets",target=""),@ResourceDependency(name="select/ordering-list.css",library="io.richwidgets",target=""),@ResourceDependency(name="select/pick-list.css",library="io.richwidgets",target=""),@ResourceDependency(name="jsf.js",library="javax.faces",target=""),@ResourceDependency(name="jquery.js",library="org.richfaces",target=""),@ResourceDependency(name="richfaces.js",library="org.richfaces",target=""),@ResourceDependency(name="richfaces-queue.reslib",library="org.richfaces",target=""),@ResourceDependency(name="jquery.ui.core.js",library="com.jqueryui",target=""),@ResourceDependency(name="jquery.ui.widget.js",library="com.jqueryui",target=""),@ResourceDependency(name="jquery.ui.position.js",library="com.jqueryui",target=""),@ResourceDependency(name="jquery.ui.mouse.js",library="com.jqueryui",target=""),@ResourceDependency(name="jquery.ui.button.js",library="com.jqueryui",target=""),@ResourceDependency(name="jquery.ui.selectable.js",library="com.jqueryui",target=""),@ResourceDependency(name="jquery.ui.sortable.js",library="com.jqueryui",target=""),@ResourceDependency(name="select/ordering-list.js",library="io.richwidgets",target=""),@ResourceDependency(name="select/pick-list.js",library="io.richwidgets",target=""),@ResourceDependency(name="bridge/bridge-base.js",library="org.richfaces",target=""),@ResourceDependency(name="bridge/select/pick-list-bridge.js",library="org.richfaces",target="")})
public class PickListRenderer extends PickListRendererBase {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES16 = attributes()
	     .generic("class","styleClass")
	     

	     .generic("onclick","onclick","click")
	     

	     .generic("ondblclick","ondblclick","dblclick")
	     

	     .generic("onkeydown","onkeydown","onkeydown")
	     

	     .generic("onkeypress","onkeypress","onkeypress")
	     

	     .generic("onkeyup","onkeyup","onkeyup")
	     

	     .generic("onmousedown","onmousedown","mousedown")
	     

	     .generic("onmousemove","onmousemove","mousemove")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     

	     .generic("onmouseover","onmouseover","mouseover")
	     

	     .generic("onmouseup","onmouseup","mouseup")
	     

	     .generic("style","style")
	     
;
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH15 = attributes()
	     .generic("disabled","disabled")
	     .defaultValue(false)

	     .generic("columnClasses","columnClasses")
	     

	     .generic("orderable","orderable")
	     .defaultValue(true)

	     .generic("pickButtonsText","pickButtonsText")
	     

	     .generic("orderButtonsText","orderButtonsText")
	     

	     .generic("switchByClick","switchByClick")
	     .defaultValue(false)

	     .generic("switchByDblClick","switchByDblClick")
	     .defaultValue(true)

	     .generic("header","caption")
	     

	     .generic("sourceHeader","sourceCaption")
	     

	     .generic("targetHeader","targetCaption")
	     

	     .generic("height","listHeight")
	     

	     .generic("heightMin","minListHeight")
	     

	     .generic("heightMax","maxListHeight")
	     
;
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH16 = attributes()
	     .generic("change","onchange","change")
	     

	     .generic("focus","onfocus","focus")
	     

	     .generic("blur","onblur","blur")
	     

	     .generic("onadditems","onadditems","additems")
	     

	     .generic("onremoveitems","onremoveitems","removeitems")
	     
;
	
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
	return false;
}

if (object instanceof Boolean) {
    return (Boolean) object;
}

return Boolean.valueOf(object.toString());
	}
	
public void renderColumnHeaders(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, Iterator columns) 
		throws IOException
	 {
		AbstractPickList component = (AbstractPickList) uiComponent;
String clientId = component.getClientId(facesContext);
responseWriter.startElement("thead", component); 

responseWriter.startElement("tr", component); 

		while (columns.hasNext()) {
		    Object columnObject = columns.next();
			UIColumn column  =  (UIColumn)columnObject; 
			responseWriter.startElement("th", component); 
			
				if (convertToBoolean(hasFacet(column,"header"))) {
	UIComponent header  =  (UIComponent)column.getHeader(); 
		if (header.isRendered()) {
	header.encodeBegin(facesContext);
	renderChildren(facesContext, header);
	header.encodeEnd(facesContext);
}
}
			responseWriter.endElement("th"); 
		}

responseWriter.endElement("tr"); 
responseWriter.endElement("thead"); 

	}
	
public void renderColumns(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, Iterator columns, Iterator clientSelectItems) 
		throws IOException
	 {
		AbstractPickList component = (AbstractPickList) uiComponent;
String clientId = component.getClientId(facesContext);
responseWriter.startElement("tbody", component); 

Map requestMap  =  (Map)facesContext.getExternalContext().getRequestMap(); 
Object oldVar  =  (Object)requestMap.get(component.getVar()); 
		while (clientSelectItems.hasNext()) {
		    Object itemObject = clientSelectItems.next();
			ClientSelectItem item  =  (ClientSelectItem)itemObject; 
			columns = component.columns();
			requestMap.put(component.getVar(), item.getSelectItem().getValue());
			responseWriter.startElement("tr", component); 
			   {
      String value = item.getConvertedValue();
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("data-key",value,null);
      }
      
   }


				ForEachLoop<Object> forEach2 = ForEachLoop.getInstance(columns);
	for (Object columnObject : forEach2) {
		ForEachLoop<Object>.Status varStatus = forEach2.getStatus();
		UIColumn column  =  (UIColumn)columnObject; 
		responseWriter.startElement("td", component); 
		
		column.encodeBegin(facesContext);
		renderChildren(facesContext, column);
		column.encodeEnd(facesContext);
		responseWriter.endElement("td"); 
	}

			responseWriter.endElement("tr"); 
		}

requestMap.put(component.getVar(), oldVar);
oldVar = null;
responseWriter.endElement("tbody"); 

	}
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
@Override
public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) 
		throws IOException
	 {
		AbstractPickList component = (AbstractPickList) uiComponent;
String clientId = component.getClientId(facesContext);
List clientSelectItems  =  (List)this.getClientSelectItems(facesContext,component); 
Iterator sourceSelectItems  =  (Iterator)this.getSourceSelectItems(clientSelectItems); 
Iterator targetSelectItems  =  (Iterator)this.getTargetSelectItems(clientSelectItems); 
responseWriter.startElement("div", component); 
   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	
renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES16);

	if ((!this.hasColumnChildren(facesContext,component))) {
	responseWriter.startElement("ol", component); 
	  responseWriter.writeAttribute("class","source",null);

   {
      String value = convertToString(clientId) + "SourceList";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


			while (sourceSelectItems.hasNext()) {
		    Object itemObject = sourceSelectItems.next();
			ClientSelectItem item  =  (ClientSelectItem)itemObject; 
			responseWriter.startElement("li", component); 
			   {
      String value = item.getConvertedValue();
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("data-key",value,null);
      }
      
   }


			{
	Object text = item.getLabel();
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

			responseWriter.endElement("li"); 
		}

	responseWriter.endElement("ol"); 
	responseWriter.startElement("ol", component); 
	  responseWriter.writeAttribute("class","target",null);

   {
      String value = convertToString(clientId) + "TargetList";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


			while (targetSelectItems.hasNext()) {
		    Object itemObject = targetSelectItems.next();
			ClientSelectItem item  =  (ClientSelectItem)itemObject; 
			responseWriter.startElement("li", component); 
			   {
      String value = item.getConvertedValue();
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("data-key",value,null);
      }
      
   }


			{
	Object text = item.getLabel();
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

			responseWriter.endElement("li"); 
		}

	responseWriter.endElement("ol"); 
	} else  { 
	Iterator columns  =  (Iterator)component.columns(); 
	responseWriter.startElement("table", component); 
	  responseWriter.writeAttribute("class","source",null);

   {
      String value = convertToString(clientId) + "SourceList";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if (((columns != null) && columns.hasNext())) {
		if (this.isHeaderExists(facesContext,component)) {
	renderColumnHeaders(responseWriter, facesContext, component, columns);
}
	renderColumns(responseWriter, facesContext, component, columns, sourceSelectItems);
}
	responseWriter.endElement("table"); 
	columns = component.columns();
	responseWriter.startElement("table", component); 
	  responseWriter.writeAttribute("class","target",null);

   {
      String value = convertToString(clientId) + "TargetList";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if (((columns != null) && columns.hasNext())) {
		if (this.isHeaderExists(facesContext,component)) {
	renderColumnHeaders(responseWriter, facesContext, component, columns);
}
	renderColumns(responseWriter, facesContext, component, columns, targetSelectItems);
}
	responseWriter.endElement("table"); 
}
responseWriter.startElement("script", component); 

Map<String, Object> options = new LinkedHashMap<String, Object>(); 

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH15, null);

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH16, ScriptHashVariableWrapper.eventHandler);

{
	Object text = "RichFaces.jQuery(document.getElementById('" + convertToString(clientId) + "')).pickListBridge(" + convertToString(toScriptArgs(options)) + ");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("script"); 
responseWriter.endElement("div"); 

	}
	
@Override
public boolean getRendersChildren() 
 {
		return true;
	}
}

