package org.richfaces.ui.select.select;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.javascript.JSReference;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;
import org.richfaces.ui.select.ClientSelectItem;
import org.richfaces.ui.select.select.SelectRendererBase;


public class SelectRenderer extends SelectRendererBase {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES14 = attributes()
	     .generic("accept","accept")
	     

	     .generic("accesskey","accesskey")
	     

	     .generic("align","align")
	     

	     .generic("alt","alt")
	     

	     .bool("checked","checked")
	     

	     .generic("dir","dir")
	     

	     .generic("lang","lang")
	     

	     .generic("maxlength","maxlength")
	     

	     .generic("onclick","onclick","click")
	     

	     .generic("ondblclick","ondblclick","dblclick")
	     

	     .generic("onkeydown","onkeydown","onkeydown")
	     

	     .generic("onkeypress","onkeypress","onkeypress")
	     

	     .generic("onkeyup","onkeyup","onkeyup")
	     

	     .generic("onmousedown","onmousedown","mousedown")
	     

	     .generic("onmousemove","onmousemove","mousemove")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     

	     .generic("onmouseover","onmouseover","mouseover")
	     

	     .generic("onmouseup","onmouseup","mouseup")
	     

	     .generic("onselect","onselect")
	     

	     .generic("role","role")
	     

	     .generic("size","size")
	     

	     .uri("src","src")
	     

	     .generic("tabindex","tabindex")
	     

	     .generic("title","title")
	     

	     .uri("usemap","usemap")
	     
;
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH11 = attributes()
	     .generic("onbegin","onbegin")
	     

	     .generic("oncomplete","oncomplete")
	     

	     .generic("onerror","onerror")
	     

	     .generic("onbeforedomupdate","onbeforedomupdate")
	     

	     .generic("onchange","onchange","change")
	     

	     .generic("onblur","onblur","blur")
	     

	     .generic("onselectitem","onselectitem","selectitem")
	     

	     .generic("onfocus","onfocus","focus")
	     

	     .generic("onlistshow","onlistshow","listshow")
	     

	     .generic("onlisthide","onlisthide","listhide")
	     
;
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH12 = attributes()
	     .generic("showControl","showControl")
	     

	     .generic("defaultLabel","defaultLabel")
	     

	     .generic("enableManualInput","enableManualInput")
	     .defaultValue(false)

	     .generic("selectFirst","selectFirst")
	     .defaultValue(true)

	     .generic("disabled","disabled")
	     .defaultValue(false)
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean isEqual(Object o1, Object o2) 
 {
		if (o1 != null) {
	return o1.equals(o2);
} else {
	//o1 == null
	return o2 == null;
}
	}
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
	return false;
}

if (object instanceof Boolean) {
    return (Boolean) object;
}

return Boolean.valueOf(object.toString());
	}
	
@Override
public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		String clientId = component.getClientId(facesContext);
List clientSelectItems  =  (List)this.getConvertedSelectItems(facesContext,component); 
Object disabled  =  (Object)component.getAttributes().get("disabled"); 
responseWriter.startElement("div", component); 
   {
      Object value = this.concatClasses("rf-sel",component.getAttributes().get("styleClass"));
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("style");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


responseWriter.startElement("span", component); 
  responseWriter.writeAttribute("class","rf-sel-cntr",null);


responseWriter.startElement("input", component); 
   {
      String value = convertToString(clientId) + "selValue";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("name",value,null);
      }
      
   }

  responseWriter.writeAttribute("type","hidden",null);

   {
      String value = this.getInputValue(facesContext,component);
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("value",value,null);
      }
      
   }


responseWriter.endElement("input"); 
String label  =  (String)this.getSelectLabel(facesContext,component); 
responseWriter.startElement("input", component); 
  responseWriter.writeAttribute("autocomplete","off",null);

   {
      String value = "rf-sel-inp" + convertToString((isEqual(label,component.getAttributes().get("defaultLabel")) ? " rf-sel-dflt-lbl" : ""));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

      if(null != disabled && ( Boolean.valueOf(disabled.toString()) || "disabled".equals(disabled.toString())) ) {
        responseWriter.writeAttribute("disabled","disabled",null);
      }

   {
      String value = convertToString(clientId) + "Input";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + "Input";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("name",value,null);
      }
      
   }

      if("readonly".equals((convertToBoolean(component.getAttributes().get("enableManualInput")) ? "" : "readonly")) || Boolean.valueOf((convertToBoolean(component.getAttributes().get("enableManualInput")) ? "" : "readonly")) ) {
        responseWriter.writeAttribute("readonly","readonly",null);
      }

  responseWriter.writeAttribute("type","text",null);

   {
      String value = label;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("value",value,null);
      }
      
   }


	
renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES14);

responseWriter.endElement("input"); 
	if (convertToBoolean(component.getAttributes().get("showButton"))) {
		if (convertToBoolean(component.getAttributes().get("disabled"))) {
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-sel-btn rf-sel-btn-dis",null);

   {
      String value = convertToString(clientId) + "Button";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-sel-btn-arrow",null);


	responseWriter.endElement("span"); 
	responseWriter.endElement("span"); 
}
		if ((!convertToBoolean(component.getAttributes().get("disabled")))) {
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-sel-btn",null);

   {
      String value = convertToString(clientId) + "Button";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-sel-btn-arrow",null);


	responseWriter.endElement("span"); 
	responseWriter.endElement("span"); 
}
}
responseWriter.endElement("span"); 
responseWriter.startElement("div", component); 
   {
      String value = this.getListCss(component);
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + "List";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


renderListHandlers(facesContext, component);;
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-sel-shdw",null);


responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-sel-shdw-t",null);


responseWriter.endElement("div"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-sel-shdw-l",null);


responseWriter.endElement("div"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-sel-shdw-r",null);


responseWriter.endElement("div"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-sel-shdw-b",null);


responseWriter.endElement("div"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-sel-lst-dcrtn",null);


responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-sel-lst-scrl",null);

   {
      String value = this.encodeHeightAndWidth(component);
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


responseWriter.startElement("div", component); 
   {
      String value = convertToString(clientId) + "Items";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


encodeItems(facesContext, component, clientSelectItems);;
responseWriter.endElement("div"); 
responseWriter.endElement("div"); 
responseWriter.endElement("div"); 
responseWriter.endElement("div"); 
responseWriter.endElement("div"); 
responseWriter.startElement("script", component); 
  responseWriter.writeAttribute("type","text/javascript",null);


Map<String, Object> options = new LinkedHashMap<String, Object>(); 
addToScriptHash(options, "clientSelectItems", clientSelectItems, null, null);

addToScriptHash(options, "itemCss", "rf-sel-opt", null, null);

addToScriptHash(options, "selectItemCss", this.concatClasses("rf-sel-sel",component.getAttributes().get("selectItemClass")), null, null);


	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH11, ScriptHashVariableWrapper.eventHandler);

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH12, null);
addToScriptHash(options, "filterFunction", this.getClientFilterFunction(component), null, null);


{
	Object text = "new RichFaces.ui.Select(\"" + convertToString(clientId) + "\", " + convertToString(toScriptArgs(options)) + ");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("script"); 
responseWriter.endElement("div"); 

	}
	
@Override
public boolean getRendersChildren() 
 {
		return true;
	}
}

