/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.request;

import java.io.IOException;
import java.io.InputStream;

import org.richfaces.model.UploadedFile;
import org.richfaces.ui.input.fileUpload.FileUploadException;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;

/**
 * @author Nick Belaevski
 *
 */
public abstract class BaseUploadedFile implements UploadedFile {
    private String parameterName;

    public BaseUploadedFile(String parameterName) {
        super();
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return parameterName;
    }

    public String getName() {
        return getHeader(MultipartRequestParser.PARAM_FILENAME);
    }

    public String getContentType() {
        return getHeader(MultipartRequestParser.PARAM_CONTENT_TYPE);
    }

    public byte[] getData() {
        long size = getSize();

        if (size > Integer.MAX_VALUE) {
            throw new FileUploadException("Resource content is too long to be allocated as byte[]");
        }

        InputStream is = null;
        try {
            is = getInputStream();
            byte[] result = new byte[(int) size];
            ByteStreams.readFully(is, result);
            return result;
        } catch (IOException e) {
            throw new FileUploadException(e.getMessage(), e);
        } finally {
            Closeables.closeQuietly(is);
        }
    }
}
