package org.richfaces.ui.ajax.push;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;
import org.richfaces.ui.ajax.push.PushRendererBase;


@ResourceDependencies({@ResourceDependency(name="ajax.reslib",library="org.richfaces",target=""),@ResourceDependency(name="base-component.reslib",library="org.richfaces",target=""),@ResourceDependency(name="richfaces-event.js",library="",target=""),@ResourceDependency(name="jquery-atmosphere.js",library="net.java.dev.atmosphere",target=""),@ResourceDependency(name="push.js",library="org.richfaces",target="")})
public class PushRenderer extends PushRendererBase {
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH15 = attributes()
	     .generic("address","address")
	     
;
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH16 = attributes()
	     .generic("ondataavailable","ondataavailable","dataavailable")
	     

	     .generic("onsubscribed","onsubscribed","subscribed")
	     

	     .generic("onerror","onerror","error")
	     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean isEmpty(Object object) 
 {
		if (object == null) {
		    return true;
		} else if (object.getClass().isArray()) {
		    return ((Object[]) object).length == 0;
		} else if (object instanceof java.util.Collection) {
		    return ((java.util.Collection<?>) object).isEmpty();
		} else if (object instanceof java.util.Map) {
		    return ((java.util.Map<?, ?>) object).isEmpty();
		} else {
			return object.toString().length() == 0;
		}
	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter();
String clientId = component.getClientId(facesContext);
responseWriter.startElement("span", component); 
   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


responseWriter.startElement("script", component); 
  responseWriter.writeAttribute("type","text/javascript",null);


	if (this.shouldEncodePushUrl(facesContext)) {
	{
	Object text = "RichFaces.Push.setPushResourceUrl(\"" + convertToString(this.getPushResourceUrl(facesContext)) + "\");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	String pushHandlerUrl  =  (String)this.getPushHandlerUrl(facesContext); 
		if ((!isEmpty(pushHandlerUrl))) {
	{
	Object text = "RichFaces.Push.setPushHandlerUrl(\"" + convertToString(pushHandlerUrl) + "\");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
}
Map<String, Object> options = new LinkedHashMap<String, Object>(); 

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH15, null);

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH16, ScriptHashVariableWrapper.eventHandler);

{
	Object text = "new RichFaces.ui.Push(" + convertToString(toScriptArgs(clientId,options)) + ");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("script"); 
responseWriter.endElement("span"); 

	}
	
@Override
public boolean getRendersChildren() 
 {
		return true;
	}
}

