/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.richfaces.ui.ajax.ajax.AjaxClientBehavior;
import org.richfaces.util.Sets;

abstract class ComponentCallback
implements VisitCallback {
    protected final FacesContext facesContext;
    private final String behaviorEvent;

    ComponentCallback(FacesContext facesContext, String behaviorEvent) {
        this.facesContext = facesContext;
        this.behaviorEvent = behaviorEvent;
    }

    private AjaxClientBehavior findBehavior(UIComponent target) {
        if (this.behaviorEvent == null || !(target instanceof ClientBehaviorHolder)) {
            return null;
        }
        ClientBehaviorHolder behaviorHolder = (ClientBehaviorHolder)target;
        List behaviors = (List)behaviorHolder.getClientBehaviors().get(this.behaviorEvent);
        if (behaviors == null) {
            return null;
        }
        for (ClientBehavior behavior : behaviors) {
            if (!(behavior instanceof AjaxClientBehavior) || ((AjaxClientBehavior)behavior).isDisabled()) continue;
            return (AjaxClientBehavior)behavior;
        }
        return null;
    }

    protected Collection<String> toCollection(Object value) {
        Set<String> result = Sets.asSet(value);
        if (result == null) {
            result = new LinkedHashSet<String>(1);
        }
        return result;
    }

    protected abstract void doVisit(UIComponent var1, AjaxClientBehavior var2);

    public final VisitResult visit(VisitContext visitContext, UIComponent target) {
        AjaxClientBehavior ajaxBehavior = null;
        if (this.behaviorEvent != null) {
            ajaxBehavior = this.findBehavior(target);
        }
        this.doVisit(target, ajaxBehavior);
        return VisitResult.COMPLETE;
    }
}

