/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.io;

import java.io.IOException;
import java.io.InputStream;
import org.richfaces.io.ByteBuffer;
import org.richfaces.io.FastBufferOutputStream;

public class FastBufferInputStream
extends InputStream {
    ByteBuffer current;
    ByteBuffer firstLink;
    int index;
    int mark;

    public FastBufferInputStream(ByteBuffer byteBuffer) {
        this.firstLink = byteBuffer;
        this.current = byteBuffer;
        this.index = 0;
        this.mark = 0;
    }

    @Deprecated
    public FastBufferInputStream(FastBufferOutputStream stream) {
        this(stream.getFirstBuffer());
    }

    @Override
    public int read() throws IOException {
        if (this.current == null) {
            return -1;
        }
        if (this.current.getUsedSize() <= this.index) {
            this.current = this.current.getNext();
            if (this.current == null) {
                return -1;
            }
            this.index = 0;
        }
        byte c = this.current.getByteAt(this.index);
        ++this.index;
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (this.current == null) {
            return -1;
        }
        int off = 0;
        int len = b.length;
        int actuallyRead = 0;
        while (this.current != null && len > 0) {
            int av = this.current.getUsedSize() - this.index;
            if (av <= 0) {
                this.current = this.current.getNext();
                this.index = 0;
                continue;
            }
            if (av > len) {
                av = len;
            }
            System.arraycopy(this.current.getBytes(), this.index, b, off, av);
            this.index += av;
            off += av;
            actuallyRead += av;
            len -= av;
        }
        return actuallyRead == 0 ? -1 : actuallyRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.current == null) {
            return -1;
        }
        int actuallyRead = 0;
        while (this.current != null && len > 0) {
            int av = this.current.getUsedSize() - this.index;
            if (av <= 0) {
                this.current = this.current.getNext();
                this.index = 0;
                continue;
            }
            if (av > len) {
                av = len;
            }
            System.arraycopy(this.current.getBytes(), this.index, b, off, av);
            this.index += av;
            off += av;
            actuallyRead += av;
            len -= av;
        }
        return actuallyRead == 0 ? -1 : actuallyRead;
    }

    @Override
    public int available() throws IOException {
        if (this.current == null) {
            return 0;
        }
        int result = -this.index;
        for (ByteBuffer b = this.current; b != null; b = b.getNext()) {
            result += b.getUsedSize();
        }
        return result;
    }

    @Override
    public void mark(int readAheadLimit) {
        if (this.current == null) {
            this.mark = 0;
        } else {
            this.mark = this.index;
            ByteBuffer b = this.current.getPrevious();
            if (b != null) {
                this.mark += b.getTotalSize();
            }
        }
    }

    @Override
    public void reset() {
        if (this.current == null) {
            this.current = this.firstLink;
        }
        int m = 0;
        while (this.current != null && this.current.getUsedSize() + m <= this.mark) {
            m += this.current.getUsedSize();
            this.current = this.current.getNext();
        }
        if (this.current != null) {
            this.index = this.mark - m;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = 0L;
        while (n > 0L) {
            if (this.current == null) {
                return 0L;
            }
            if ((long)(this.current.getUsedSize() - this.index) <= n) {
                this.index = (int)((long)this.index + n);
                skipped += n;
                break;
            }
            int dn = this.current.getUsedSize() - this.index;
            skipped += (long)dn;
            n -= (long)dn;
            this.current = this.current.getNext();
            this.index = 0;
        }
        return skipped;
    }
}

