/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.javascript;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceDependency;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.richfaces.javascript.ClientScriptService;
import org.richfaces.javascript.ClientSideScript;
import org.richfaces.javascript.LibraryFunction;
import org.richfaces.javascript.LibraryFunctionImplementation;
import org.richfaces.javascript.ScriptNotFoundException;
import org.richfaces.resource.ResourceKey;

public class ClientScriptServiceImpl
implements ClientScriptService {
    private static final String TEXT_JAVASCRIPT = "text/javascript";
    private static final String ORG_RICHFACES_CSV = "org.richfaces.csv";
    private static final LibraryFunction NO_SCRIPT = new LibraryFunction(){

        @Override
        public Iterable<ResourceKey> getResources() {
            return Collections.emptySet();
        }

        @Override
        public String getName() {
            return null;
        }
    };
    private static final Function<Class<?>, LibraryFunction> RESOURCE_SCRIPT_FUNCTION = new Function<Class<?>, LibraryFunction>(){

        public LibraryFunction apply(Class<?> arg0) {
            return ClientScriptServiceImpl.getScriptResource(FacesContext.getCurrentInstance(), arg0);
        }
    };
    private static final Function<Class<?>, LibraryFunction> ANNOTATION_SCRIPT_FUNCTION = new Function<Class<?>, LibraryFunction>(){

        public LibraryFunction apply(Class<?> arg0) {
            return ClientScriptServiceImpl.getScriptFromAnnotation(arg0);
        }
    };
    private final LoadingCache<Class<?>, LibraryFunction> resourcesMapping;
    private final LoadingCache<Class<?>, LibraryFunction> annotationsMapping;
    private final Map<Class<?>, LibraryFunction> defaultMapping;

    public ClientScriptServiceImpl(Map<Class<?>, LibraryFunction> defaultMapping) {
        this.defaultMapping = defaultMapping;
        this.resourcesMapping = CacheBuilder.newBuilder().initialCapacity(10).build(CacheLoader.from(RESOURCE_SCRIPT_FUNCTION));
        this.annotationsMapping = CacheBuilder.newBuilder().initialCapacity(10).build(CacheLoader.from(ANNOTATION_SCRIPT_FUNCTION));
    }

    @Override
    public LibraryFunction getScript(FacesContext facesContext, Class<?> javaClass) throws ScriptNotFoundException {
        if (null == facesContext || null == javaClass) {
            throw new NullPointerException();
        }
        LibraryFunction function = NO_SCRIPT;
        if (NO_SCRIPT == function) {
            function = this.defaultMapping.containsKey(javaClass) ? this.defaultMapping.get(javaClass) : this.getFromLoadingCache(this.annotationsMapping, javaClass);
        }
        if (NO_SCRIPT == function) {
            throw new ScriptNotFoundException("No client-side script for class " + javaClass.getName());
        }
        return function;
    }

    private LibraryFunction getFromLoadingCache(LoadingCache<Class<?>, LibraryFunction> cache, Class<?> clazz) {
        try {
            return (LibraryFunction)cache.get(clazz);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new FacesException(cause);
        }
    }

    private static LibraryFunction getScriptFromAnnotation(Class<?> javaClass) {
        if (javaClass.isAnnotationPresent(ClientSideScript.class)) {
            ClientSideScript clientSideScript = javaClass.getAnnotation(ClientSideScript.class);
            ArrayList resources = Lists.newArrayList();
            for (ResourceDependency dependency : clientSideScript.resources()) {
                resources.add(ResourceKey.create(dependency.name(), dependency.library()));
            }
            return new LibraryFunctionImplementation(clientSideScript.function(), resources);
        }
        return NO_SCRIPT;
    }

    private static LibraryFunction getScriptResource(FacesContext facesContext, Class<?> javaClass) {
        String resourceName;
        ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
        Resource facesResource = resourceHandler.createResource(resourceName = javaClass.getSimpleName() + ".js", ORG_RICHFACES_CSV, TEXT_JAVASCRIPT);
        if (null != facesResource) {
            String functionName = ClientScriptServiceImpl.firstToLowerCase(javaClass.getSimpleName());
            return new LibraryFunctionImplementation(functionName, resourceName, ORG_RICHFACES_CSV);
        }
        return NO_SCRIPT;
    }

    private static String firstToLowerCase(String in) {
        if (Strings.isNullOrEmpty((String)in)) {
            return in;
        }
        return in.substring(0, 1).toLowerCase() + in.substring(1);
    }
}

