/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.javascript;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

final class PropertyUtils {
    private static final PropertyDescriptor[] EMPTY_DESCRIPTORS_ARRAY = new PropertyDescriptor[0];
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();

    private PropertyUtils() {
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("argument is null");
        }
        PropertyDescriptor[] descriptors = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            descriptors = beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            LOGGER.error(e.getMessage(), e);
        }
        if (descriptors == null) {
            descriptors = EMPTY_DESCRIPTORS_ARRAY;
        }
        return descriptors;
    }

    public static Object readPropertyValue(Object bean, PropertyDescriptor descriptor) throws Exception {
        Method readMethod = descriptor.getReadMethod();
        if (readMethod == null) {
            throw new NoSuchMethodException(MessageFormat.format("Read method for property ''{0}'' not found", descriptor.getName()));
        }
        try {
            return readMethod.invoke(bean, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw e;
        }
    }
}

