/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.l10n;

import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.richfaces.l10n.BundleLoader;
import org.richfaces.l10n.MessageBundle;
import org.richfaces.l10n.MessageFactory;

public class MessageFactoryImpl
implements MessageFactory {
    private static final Factory<FacesMessage> MESSAGE_FACTORY = new Factory<FacesMessage>(){

        @Override
        public FacesMessage create(ResourceBundle bundle, Enum<?> messageKey, Object ... args) throws MissingResourceException {
            String messageId = messageKey.toString();
            String summary = null;
            String detail = null;
            try {
                summary = bundle.getString(messageId);
                detail = bundle.getString(messageId + "_detail");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (summary != null) {
                String formattedSummary = MessageFormat.format(summary, args);
                String formattedDetail = null;
                if (detail != null) {
                    formattedDetail = MessageFormat.format(detail, args);
                }
                return new FacesMessage(formattedSummary, formattedDetail);
            }
            return null;
        }
    };
    private static final Factory<String> LABEL_FACTORY = new Factory<String>(){

        @Override
        public String create(ResourceBundle bundle, Enum<?> messageKey, Object ... args) throws MissingResourceException {
            String pattern = bundle.getString(messageKey.toString());
            return MessageFormat.format(pattern, args);
        }
    };
    private static final Factory<String> FORMAT_FACTORY = new Factory<String>(){

        @Override
        public String create(ResourceBundle bundle, Enum<?> messageKey, Object ... args) throws MissingResourceException {
            String format = bundle.getString(messageKey.toString());
            return format;
        }
    };
    private BundleLoader bundleLoader;

    public MessageFactoryImpl(BundleLoader bundleLoader) {
        this.bundleLoader = bundleLoader;
    }

    private Locale detectLocale(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot != null && viewRoot.getLocale() != null) {
            return viewRoot.getLocale();
        }
        return null;
    }

    @Override
    public FacesMessage createMessage(FacesContext facesContext, Enum<?> messageKey, Object ... args) {
        return this.createMessage(facesContext, FacesMessage.SEVERITY_INFO, messageKey, args);
    }

    @Override
    public FacesMessage createMessage(FacesContext facesContext, FacesMessage.Severity severity, Enum<?> messageKey, Object ... args) {
        if (facesContext == null) {
            throw new NullPointerException("context");
        }
        if (severity == null) {
            throw new NullPointerException("severity");
        }
        if (messageKey == null) {
            throw new NullPointerException("messageKey");
        }
        FacesMessage result = this.detectLocalesAndCreate(facesContext, MESSAGE_FACTORY, messageKey, args);
        if (result != null) {
            result.setSeverity(severity);
        }
        return result;
    }

    @Override
    public String getMessageText(FacesContext facesContext, Enum<?> messageKey, Object ... args) {
        String text = this.detectLocalesAndCreate(facesContext, LABEL_FACTORY, messageKey, args);
        if (text == null) {
            text = "???" + messageKey + "???";
        }
        return text;
    }

    @Override
    public String getMessageFormat(FacesContext facesContext, Enum<?> messageKey) {
        String text = this.detectLocalesAndCreate(facesContext, FORMAT_FACTORY, messageKey, new Object[0]);
        if (Strings.isNullOrEmpty((String)text)) {
            throw new IllegalStateException("Format not found");
        }
        return text;
    }

    protected <T> T detectLocalesAndCreate(FacesContext context, Factory<T> factory, Enum<?> messageKey, Object ... args) {
        Locale defaultLocale;
        T result = null;
        Locale locale = this.detectLocale(context);
        if (locale != null) {
            result = this.create(context, factory, locale, messageKey, args);
        }
        if (result == null && !(defaultLocale = Locale.getDefault()).equals(locale)) {
            result = this.create(context, factory, defaultLocale, messageKey, args);
        }
        return result;
    }

    protected <T> T create(FacesContext context, Factory<T> factory, Locale locale, Enum<?> messageKey, Object ... args) {
        ResourceBundle bundle;
        MessageBundle messageBundle = messageKey.getClass().getAnnotation(MessageBundle.class);
        if (messageBundle == null) {
            return null;
        }
        T result = null;
        try {
            bundle = this.bundleLoader.getApplicationBundle(context, messageKey, locale);
            result = factory.create(bundle, messageKey, args);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (result == null) {
            try {
                bundle = this.bundleLoader.getBundle(messageKey, locale);
                result = factory.create(bundle, messageKey, args);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return result;
    }

    protected static interface Factory<T> {
        public T create(ResourceBundle var1, Enum<?> var2, Object ... var3) throws MissingResourceException;
    }
}

