/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.richfaces.javascript.ScriptUtils;
import org.richfaces.push.PushContext;
import org.richfaces.push.PushContextFactory;
import org.richfaces.push.Session;
import org.richfaces.push.TopicKey;
import org.richfaces.resource.AbstractUserResource;
import org.richfaces.resource.DynamicResource;
import org.richfaces.services.ServiceTracker;

@DynamicResource
public class PushResource
extends AbstractUserResource {
    private static final String PUSH_TOPIC_PARAM = "pushTopic";
    private static final String FORGET_PUSH_SESSION_ID_PARAM = "forgetPushSessionId";

    private Map<String, String> getFailuresMap(Map<TopicKey, String> failedSubscriptions) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<TopicKey, String> entry : failedSubscriptions.entrySet()) {
            result.put(entry.getKey().getTopicAddress(), entry.getValue());
        }
        return result;
    }

    @Override
    public void encode(FacesContext facesContext) throws IOException {
        Session oldSession;
        ExternalContext externalContext = facesContext.getExternalContext();
        PushContextFactory pushContextFactory = ServiceTracker.getService(PushContextFactory.class);
        if (pushContextFactory == null) {
            return;
        }
        PushContext pushContext = pushContextFactory.getPushContext();
        String forgetPushSessionId = (String)externalContext.getRequestParameterMap().get(FORGET_PUSH_SESSION_ID_PARAM);
        if (forgetPushSessionId != null && (oldSession = pushContext.getSessionManager().getPushSession(forgetPushSessionId)) != null) {
            oldSession.invalidate();
        }
        Session session = pushContext.getSessionFactory().createSession(UUID.randomUUID().toString());
        String[] topicNames = (String[])externalContext.getRequestParameterValuesMap().get(PUSH_TOPIC_PARAM);
        if (topicNames == null) {
            throw new IllegalArgumentException("pushTopic request parameter must be present");
        }
        session.subscribe(topicNames);
        HashMap<String, Object> subscriptionData = new HashMap<String, Object>(4);
        subscriptionData.put("sessionId", session.getId());
        Map<TopicKey, String> failedSubscriptions = session.getFailedSubscriptions();
        subscriptionData.put("failures", this.getFailuresMap(failedSubscriptions));
        Writer outWriter = facesContext.getExternalContext().getResponseOutputWriter();
        ScriptUtils.appendScript(outWriter, subscriptionData);
    }

    @Override
    public String getContentType() {
        return "text/javascript; charset=utf-8";
    }
}

