/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.richfaces.el.ELUtils;
import org.richfaces.resource.ResourceLoadingOptimization;
import org.richfaces.resource.ResourceMappingConfiguration;

public final class ResourceMappingFeature {
    static final String DEFAULT_LOCATION = "#{facesContext.externalContext.requestContextPath}/org.richfaces.resources/javax.faces.resource/#{resourceLocation}";

    private ResourceMappingFeature() {
    }

    public static List<String> getMappingFiles() {
        LinkedList mappingFiles = Lists.newLinkedList();
        if (ResourceLoadingOptimization.isEnabled()) {
            mappingFiles.add(ResourceLoadingOptimization.getResourceLoadingSpecificMappingFile());
        }
        mappingFiles.add(ResourceMappingFeature.getDefaultMappingFile());
        mappingFiles.addAll(ResourceMappingFeature.getUserConfiguredMappingFile());
        return mappingFiles;
    }

    private static String getDefaultMappingFile() {
        return "META-INF/richfaces/static-resource-mappings.properties";
    }

    private static List<String> getUserConfiguredMappingFile() {
        String configured = ResourceMappingConfiguration.getResourceMappingFile();
        if (configured == null) {
            return Arrays.asList(new Object[0]);
        }
        return Arrays.asList(configured.split(","));
    }

    public static String getLocation() {
        ValueExpression mappingLocationExpression = ELUtils.createValueExpression(ResourceMappingFeature.getLocationAsExpression());
        return mappingLocationExpression.getValue(FacesContext.getCurrentInstance().getELContext()).toString();
    }

    private static String getLocationAsExpression() {
        String location = ResourceMappingConfiguration.getLocation();
        if (location == null) {
            return DEFAULT_LOCATION;
        }
        return location;
    }
}

