/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import java.util.concurrent.atomic.AtomicReference;
import javax.faces.context.FacesContext;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceSkinUtils;
import org.richfaces.resource.external.AbsoluteRequestPathResource;
import org.richfaces.resource.external.ExternalResource;
import org.richfaces.resource.external.ExternalStaticResource;
import org.richfaces.util.URLUtils;

public class ExternalMapping {
    private ResourceKey resourceKey;
    private String resourceLocation;
    private AtomicReference<ExternalResource> resourceReference = new AtomicReference();

    public ExternalMapping(ResourceKey resourceKey, String resourceLocation) {
        this.resourceKey = resourceKey;
        this.resourceLocation = resourceLocation;
    }

    public ExternalResource getResource(FacesContext facesContext) {
        ExternalResource resource = this.resourceReference.get();
        if (resource == null) {
            boolean skinDependent = false;
            if (ResourceSkinUtils.isSkinDependent(this.resourceLocation)) {
                skinDependent = true;
            }
            resource = URLUtils.isValidURL(this.resourceLocation) ? new AbsoluteRequestPathResource(this.resourceLocation) : new ExternalStaticResource(this.resourceLocation, skinDependent);
            resource.setResourceName(this.resourceKey.getResourceName());
            resource.setLibraryName(this.resourceKey.getLibraryName());
            resource.setContentType(facesContext.getExternalContext().getMimeType(this.resourceLocation));
            this.resourceReference.compareAndSet(null, resource);
            resource = this.resourceReference.get();
        }
        return resource;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }
}

