/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.ajax.command;

import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.ui.behavior.HandlersChain;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib")})
public abstract class AjaxCommandRendererBase
extends RendererBase {
    private static final Logger LOG = RichfacesLogger.RENDERKIT.getLogger();

    @Override
    protected void queueComponentEventForBehaviorEvent(FacesContext context, UIComponent component, String eventName) {
        super.queueComponentEventForBehaviorEvent(context, component, eventName);
        if ("action".equals(eventName) || "click".equals(eventName)) {
            new ActionEvent(component).queue();
        }
    }

    @Override
    protected void doDecode(FacesContext facesContext, UIComponent uiComponent) {
        if (this.isSubmitted(facesContext, uiComponent)) {
            new ActionEvent(uiComponent).queue();
        }
    }

    protected boolean isSubmitted(FacesContext facesContext, UIComponent uiComponent) {
        boolean submitted;
        if (this.getUtils().isBooleanAttribute(uiComponent, "disabled")) {
            return false;
        }
        String clientId = uiComponent.getClientId(facesContext);
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        Object value = paramMap.get(clientId);
        boolean bl = submitted = null != value;
        if (submitted && LOG.isDebugEnabled()) {
            LOG.debug("Decode submit of the Ajax component " + clientId);
        }
        return submitted;
    }

    public String getOnClick(FacesContext context, UIComponent component) {
        StringBuffer onClick = new StringBuffer();
        if (!this.getUtils().isBooleanAttribute(component, "disabled")) {
            HandlersChain handlersChain = new HandlersChain(context, component);
            handlersChain.addInlineHandlerFromAttribute("onclick");
            handlersChain.addBehaviors("click", "action");
            handlersChain.addAjaxSubmitFunction();
            String handlerScript = handlersChain.toScript();
            if (handlerScript != null) {
                onClick.append(handlerScript);
            }
            if (!"reset".equals(component.getAttributes().get("type"))) {
                onClick.append(";return false;");
            }
        } else {
            onClick.append("return false;");
        }
        return onClick.toString();
    }
}

