/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.ajax.push;

import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.richfaces.javascript.ScriptUtils;
import org.richfaces.push.PushContext;
import org.richfaces.push.PushContextFactory;
import org.richfaces.resource.PushResource;
import org.richfaces.services.ServiceTracker;
import org.richfaces.ui.ajax.push.AbstractPush;

public class PushRendererBase
extends Renderer {
    private static final String PUSH_URL_ENCODED_ATTRIBUTE = PushRendererBase.class.getName();

    protected String getPushResourceUrl(FacesContext context) {
        ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
        Resource pushResource = resourceHandler.createResource(PushResource.class.getName());
        return pushResource.getRequestPath();
    }

    protected String getPushHandlerUrl(FacesContext context) {
        PushContext pushContext = ServiceTracker.getService(PushContextFactory.class).getPushContext();
        return pushContext.getPushHandlerUrl();
    }

    protected boolean shouldEncodePushUrl(FacesContext context) {
        Map attributes = context.getAttributes();
        if (attributes.get(PUSH_URL_ENCODED_ATTRIBUTE) == null) {
            attributes.put(PUSH_URL_ENCODED_ATTRIBUTE, Boolean.TRUE);
            return true;
        }
        return false;
    }

    protected String getOptionsString(FacesContext context, UIComponent component) {
        AbstractPush push = (AbstractPush)component;
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("address", push.getAddress());
        options.put("dataHandler", push.getOndataavailable());
        options.put("errorHandler", push.getOnerror());
        return ScriptUtils.toScript(options);
    }
}

