/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.view.AttachedObjectHandler;

public final class TagHandlerUtils {
    private static final String JAVAX_FACES_RETARGETABLE_HANDLERS = "javax.faces.RetargetableHandlers";

    private TagHandlerUtils() {
    }

    public static List<AttachedObjectHandler> getOrCreateRetargetableHandlersList(UIComponent component) {
        Map attrs = component.getAttributes();
        ArrayList list = (ArrayList)attrs.get(JAVAX_FACES_RETARGETABLE_HANDLERS);
        if (list == null) {
            list = new ArrayList();
            attrs.put(JAVAX_FACES_RETARGETABLE_HANDLERS, list);
        }
        return list;
    }

    public static <T> Class<? extends T> loadClass(String className, Class<T> type) throws ClassNotFoundException, ClassCastException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Class<?> loadedClass = Class.forName(className, false, ccl);
        return loadedClass.asSubclass(type);
    }
}

