/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.drag.dropTarget;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.ui.drag.dropTarget.DropEvent;
import org.richfaces.ui.drag.dropTarget.DropListener;

public abstract class AbstractDropTarget
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.richfaces.DropTarget";
    public static final String COMPONENT_FAMILY = "org.richfaces.DropTarget";

    @Attribute
    public abstract Object getDropValue();

    @Attribute
    public abstract boolean isImmediate();

    @Attribute
    public abstract boolean isBypassUpdates();

    @Attribute
    public abstract Object getExecute();

    @Attribute
    public abstract Object getRender();

    @Attribute
    public abstract Object getAcceptedTypes();

    @Attribute
    public abstract boolean isLimitRender();

    @Attribute
    public abstract Object getData();

    @Attribute
    public abstract String getStatus();

    @Attribute(events={@EventName(value="beforedomupdate")})
    public abstract String getOnbeforedomupdate();

    @Attribute(events={@EventName(value="complete")})
    public abstract String getOncomplete();

    @Attribute(events={@EventName(value="begin")})
    public abstract String getOnbegin();

    public void addDropListener(DropListener listener) {
        this.addFacesListener(listener);
    }

    public DropListener[] getDropListeners() {
        return (DropListener[])this.getFacesListeners(DropListener.class);
    }

    public void removeDropListener(DropListener listener) {
        this.removeFacesListener(listener);
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof DropEvent) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (this.isBypassUpdates()) {
                event.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof DropEvent && (this.isBypassUpdates() || this.isImmediate())) {
            FacesContext.getCurrentInstance().renderResponse();
        }
    }
}

