/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.images;

import java.util.Locale;

public enum GradientAlignment {
    top{

        @Override
        public int getBottomRectangleHeight(int imageHeight, int gradientHeight) {
            return Math.max(imageHeight - gradientHeight, 0);
        }

        @Override
        public int getTopRectangleHeight(int imageHeight, int gradientHeight) {
            return 0;
        }
    }
    ,
    middle{

        @Override
        public int getBottomRectangleHeight(int imageHeight, int gradientHeight) {
            return Math.max((imageHeight - gradientHeight) / 2, 0);
        }

        @Override
        public int getTopRectangleHeight(int imageHeight, int gradientHeight) {
            return this.getBottomRectangleHeight(imageHeight, gradientHeight);
        }
    }
    ,
    bottom{

        @Override
        public int getBottomRectangleHeight(int imageHeight, int gradientHeight) {
            return 0;
        }

        @Override
        public int getTopRectangleHeight(int imageHeight, int gradientHeight) {
            return Math.max(imageHeight - gradientHeight, 0);
        }
    };


    public static final GradientAlignment getByParameter(String string) {
        if (string == null || string.length() == 0) {
            return middle;
        }
        return GradientAlignment.valueOf(string.toLowerCase(Locale.US));
    }

    public abstract int getTopRectangleHeight(int var1, int var2);

    public abstract int getBottomRectangleHeight(int var1, int var2);
}

