/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.images;

import java.awt.Color;
import java.util.Locale;

public enum GradientType {
    glass{

        @Override
        public BiColor getFirstLayerColors(BiColor biColor) {
            Color bottomColor = biColor.getBottomColor();
            if (bottomColor != null) {
                float[] hsb = Color.RGBtoHSB(bottomColor.getRed(), bottomColor.getGreen(), bottomColor.getBlue(), null);
                hsb[2] = 0.2f * hsb[2] + 0.8f;
                hsb[1] = 0.5f * hsb[1];
                Color topColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
                return new BiColor(bottomColor, topColor);
            }
            return null;
        }

        @Override
        public BiColor getSecondLayerColors(BiColor biColor) {
            if (biColor.getBottomColor() != null) {
                return WHITE;
            }
            return null;
        }
    }
    ,
    plastic{

        @Override
        public BiColor getFirstLayerColors(BiColor biColor) {
            Color bottomColor = biColor.getBottomColor();
            if (bottomColor != null) {
                float[] hsb = Color.RGBtoHSB(bottomColor.getRed(), bottomColor.getGreen(), bottomColor.getBlue(), null);
                hsb[2] = 0.25f * hsb[2] + 0.75f;
                hsb[1] = 0.75f * hsb[1];
                Color topColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
                return new BiColor(topColor, bottomColor);
            }
            return null;
        }

        @Override
        public BiColor getSecondLayerColors(BiColor biColor) {
            if (biColor.getBottomColor() != null) {
                return WHITE;
            }
            return null;
        }
    }
    ,
    plain{

        @Override
        public BiColor getFirstLayerColors(BiColor biColor) {
            if (biColor.getBottomColor() != null && biColor.getTopColor() != null) {
                return biColor;
            }
            return null;
        }

        @Override
        public BiColor getSecondLayerColors(BiColor biColor) {
            return null;
        }
    };

    private static final BiColor WHITE;

    public static final GradientType getByParameter(String string) {
        if (string == null || string.length() == 0) {
            return plain;
        }
        return GradientType.valueOf(string.toLowerCase(Locale.US));
    }

    public abstract BiColor getFirstLayerColors(BiColor var1);

    public abstract BiColor getSecondLayerColors(BiColor var1);

    static {
        WHITE = new BiColor(new Color(255, 255, 255, 165), new Color(255, 255, 255, 51));
    }

    public static class BiColor {
        private Color bottomColor;
        private Color topColor;

        public BiColor(Color topColor, Color bottomColor) {
            this.topColor = topColor;
            this.bottomColor = bottomColor;
        }

        public BiColor(Integer topColor, Integer bottomColor) {
            this.topColor = topColor != null ? new Color(topColor) : null;
            this.bottomColor = bottomColor != null ? new Color(bottomColor) : null;
        }

        public Color getTopColor() {
            return this.topColor;
        }

        public Color getBottomColor() {
            return this.bottomColor;
        }

        public String toString() {
            return "BiColor: [" + this.topColor + " -> " + this.bottomColor + "]";
        }
    }
}

