/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.input.autocomplete;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.servlet.jsp.jstl.sql.Result;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.el.GenericsIntrospectionService;
import org.richfaces.javascript.JSObject;
import org.richfaces.javascript.JSReference;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.services.ServiceTracker;
import org.richfaces.ui.common.meta.MetaComponentRenderer;
import org.richfaces.ui.input.InputRendererBase;
import org.richfaces.ui.input.autocomplete.AbstractAutocomplete;
import org.richfaces.ui.input.autocomplete.AutocompleteDivLayoutStrategy;
import org.richfaces.ui.input.autocomplete.AutocompleteEncodeStrategy;
import org.richfaces.ui.input.autocomplete.AutocompleteLayout;
import org.richfaces.ui.input.autocomplete.AutocompleteListLayoutStrategy;
import org.richfaces.ui.input.autocomplete.AutocompleteMode;
import org.richfaces.ui.input.autocomplete.AutocompleteTableLayoutStrategy;
import org.richfaces.util.InputUtils;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(name="jquery.position.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-utils.js"), @ResourceDependency(name="richfaces-selection.js"), @ResourceDependency(library="org.richfaces", name="AutocompleteBase.js"), @ResourceDependency(library="org.richfaces", name="Autocomplete.js"), @ResourceDependency(library="org.richfaces", name="Autocomplete.ecss")})
public abstract class AutocompleteRendererBase
extends InputRendererBase
implements MetaComponentRenderer {
    private static final Logger LOGGER = RichfacesLogger.RENDERKIT.getLogger();

    public JSReference getClientFilterFunction(UIComponent component) {
        AbstractAutocomplete autocomplete = (AbstractAutocomplete)component;
        String clientFilter = (String)autocomplete.getAttributes().get("clientFilterFunction");
        if (clientFilter != null && clientFilter.length() != 0) {
            return new JSReference(clientFilter);
        }
        return null;
    }

    private DataModel<Object> getItems(FacesContext facesContext, AbstractAutocomplete component) {
        ArrayDataModel result;
        Object itemsObject = null;
        MethodExpression autocompleteMethod = component.getAutocompleteMethod();
        if (autocompleteMethod != null) {
            Map requestParameters = facesContext.getExternalContext().getRequestParameterMap();
            String value = (String)requestParameters.get(component.getClientId(facesContext) + "Value");
            try {
                try {
                    itemsObject = autocompleteMethod.invoke(facesContext.getELContext(), new Object[]{facesContext, component, value});
                }
                catch (MethodNotFoundException e) {
                    ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
                    autocompleteMethod = expressionFactory.createMethodExpression(facesContext.getELContext(), autocompleteMethod.getExpressionString(), Object.class, new Class[]{String.class});
                    itemsObject = autocompleteMethod.invoke(facesContext.getELContext(), new Object[]{value});
                }
            }
            catch (ELException ee) {
                LOGGER.error(ee.getMessage(), ee);
            }
        } else {
            itemsObject = component.getAutocompleteList();
        }
        if (itemsObject instanceof Object[]) {
            result = new ArrayDataModel((Object[])itemsObject);
        } else if (itemsObject instanceof List) {
            result = new ListDataModel((List)itemsObject);
        } else if (itemsObject instanceof Result) {
            result = new ResultDataModel((Result)itemsObject);
        } else if (itemsObject instanceof ResultSet) {
            result = new ResultSetDataModel((ResultSet)itemsObject);
        } else if (itemsObject != null) {
            ArrayList temp = new ArrayList();
            Iterator iterator = ((Iterable)itemsObject).iterator();
            while (iterator.hasNext()) {
                temp.add(iterator.next());
            }
            result = new ListDataModel(temp);
        } else {
            result = new ListDataModel(null);
        }
        return result;
    }

    private Object saveVar(FacesContext context, String var) {
        if (var != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            return requestMap.get(var);
        }
        return null;
    }

    private void setVar(FacesContext context, String var, Object varObject) {
        if (var != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            requestMap.put(var, varObject);
        }
    }

    protected void encodeItems(FacesContext facesContext, UIComponent component, List<Object> fetchValues) throws IOException {
        AbstractAutocomplete comboBox = (AbstractAutocomplete)component;
        AutocompleteEncodeStrategy strategy = this.getStrategy(component);
        strategy.encodeItemsContainerBegin(facesContext, component);
        Object savedVar = this.saveVar(facesContext, comboBox.getVar());
        Iterator itemsIterator = this.getItems(facesContext, comboBox).iterator();
        if (!itemsIterator.hasNext()) {
            strategy.encodeFakeItem(facesContext, component);
        } else {
            while (itemsIterator.hasNext()) {
                Object item = itemsIterator.next();
                this.setVar(facesContext, comboBox.getVar(), item);
                this.encodeItem(facesContext, comboBox, item, strategy);
                if (comboBox.getFetchValue() != null) {
                    fetchValues.add(comboBox.getFetchValue().toString());
                    continue;
                }
                if (item == null) continue;
                fetchValues.add(item.toString());
            }
        }
        this.setVar(facesContext, comboBox.getVar(), savedVar);
        strategy.encodeItemsContainerEnd(facesContext, component);
    }

    protected void encodeItemsContainer(FacesContext facesContext, UIComponent component) throws IOException {
        AutocompleteEncodeStrategy strategy = this.getStrategy(component);
        AutocompleteMode mode = (AutocompleteMode)((Object)component.getAttributes().get("mode"));
        if (mode != null && mode == AutocompleteMode.client) {
            ArrayList<Object> fetchValues = new ArrayList<Object>();
            this.encodeItems(facesContext, component, fetchValues);
            this.encodeFetchValues(facesContext, component, fetchValues);
        } else {
            strategy.encodeItemsContainerBegin(facesContext, component);
            strategy.encodeItemsContainerEnd(facesContext, component);
        }
    }

    private void encodeFetchValues(FacesContext facesContext, UIComponent component, List<Object> fetchValues) throws IOException {
        if (!fetchValues.isEmpty()) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            JSObject script = new JSObject("RichFaces.ui.Autocomplete.setData", component.getClientId(facesContext) + "Items", fetchValues);
            writer.writeText((Object)script, null);
            writer.endElement("script");
        }
    }

    public void encodeItem(FacesContext facesContext, AbstractAutocomplete comboBox, Object item, AutocompleteEncodeStrategy strategy) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (comboBox.getChildCount() > 0) {
            strategy.encodeItem(facesContext, (UIComponent)comboBox);
        } else if (item != null) {
            strategy.encodeItemBegin(facesContext, (UIComponent)comboBox);
            writer.writeAttribute("class", (Object)"rf-au-itm rf-au-opt rf-au-fnt rf-au-inp", null);
            writer.writeText(item, null);
            strategy.encodeItemEnd(facesContext, (UIComponent)comboBox);
        }
    }

    private AutocompleteEncodeStrategy getStrategy(UIComponent component) {
        AbstractAutocomplete comboBox = (AbstractAutocomplete)component;
        if (comboBox.getLayout() != null) {
            if (comboBox.getLayout().equals(AutocompleteLayout.div.toString())) {
                return new AutocompleteDivLayoutStrategy();
            }
            if (comboBox.getLayout().equals(AutocompleteLayout.list.toString())) {
                return new AutocompleteListLayoutStrategy();
            }
            if (comboBox.getLayout().equals(AutocompleteLayout.table.toString())) {
                return new AutocompleteTableLayoutStrategy();
            }
        }
        return new AutocompleteDivLayoutStrategy();
    }

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        AbstractAutocomplete autocomplete = (AbstractAutocomplete)component;
        if (InputUtils.isDisabled((UIComponent)autocomplete)) {
            return;
        }
        Map requestParameters = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestParameters.get(component.getClientId(context) + "Input");
        if (value != null) {
            autocomplete.setSubmittedValue(value);
        }
        if (requestParameters.get(component.getClientId(context) + ".ajax") != null) {
            PartialViewContext pvc = context.getPartialViewContext();
            pvc.getRenderIds().add(component.getClientId(context) + '@' + "items");
            context.renderResponse();
        }
    }

    @Override
    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        if ("items".equals(metaComponentId)) {
            ArrayList<Object> fetchValues = new ArrayList<Object>();
            PartialResponseWriter partialWriter = context.getPartialViewContext().getPartialResponseWriter();
            partialWriter.startUpdate(this.getStrategy(component).getContainerElementId(context, component));
            this.encodeItems(context, component, fetchValues);
            partialWriter.endUpdate();
            if (!fetchValues.isEmpty()) {
                Map<String, Object> dataMap = ExtendedPartialViewContext.getInstance(context).getResponseComponentDataMap();
                dataMap.put(component.getClientId(context), fetchValues);
            }
        } else {
            throw new IllegalArgumentException(metaComponentId);
        }
    }

    @Override
    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
        throw new UnsupportedOperationException();
    }

    protected int getMinCharsOrDefault(UIComponent component) {
        int value = 1;
        if (component instanceof AbstractAutocomplete && (value = ((AbstractAutocomplete)component).getMinChars()) < 1) {
            value = 1;
        }
        return value;
    }

    private Converter getConverterForValue(FacesContext context, UIComponent component) {
        ValueExpression expression;
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null && (expression = component.getValueExpression("value")) != null) {
            Class<?> containerClass = ServiceTracker.getService(context, GenericsIntrospectionService.class).getContainerClass(context, expression);
            converter = InputUtils.getConverterForType(context, containerClass);
        }
        return converter;
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object val) throws ConverterException {
        String s = (String)val;
        Converter converter = this.getConverterForValue(context, component);
        if (converter != null) {
            return converter.getAsObject(context, component, s);
        }
        return s;
    }
}

