/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.collapsibleSubTable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

public class StateHolderArray
implements StateHolder {
    private boolean tranzient = false;
    private ArrayList<Object> backingList = Lists.newArrayListWithCapacity((int)2);

    public Object saveState(FacesContext context) {
        Object[] savedState = new Object[this.backingList.size()];
        boolean hasNonNullState = false;
        for (int i = 0; i < savedState.length; ++i) {
            Object state;
            savedState[i] = state = UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.backingList.get(i));
            if (state == null) continue;
            hasNonNullState = true;
        }
        if (hasNonNullState) {
            return savedState;
        }
        return null;
    }

    public void restoreState(FacesContext context, Object stateObject) {
        if (stateObject != null) {
            Object[] state = (Object[])stateObject;
            this.backingList.ensureCapacity(state.length);
            for (int i = 0; i < state.length; ++i) {
                this.backingList.add(UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[i]));
            }
        }
    }

    public boolean isTransient() {
        return this.tranzient;
    }

    public void setTransient(boolean newTransientValue) {
        this.tranzient = newTransientValue;
    }

    public boolean add(Object e) {
        return this.backingList.add(e);
    }

    public Object get(int index) {
        return this.backingList.get(index);
    }

    public boolean isEmpty() {
        return this.backingList.isEmpty();
    }
}

