/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.dataTable;

import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import org.richfaces.ui.iteration.FilteringEvent;
import org.richfaces.ui.iteration.RowKeyConverterRule;
import org.richfaces.ui.iteration.SortingEvent;
import org.richfaces.ui.iteration.dataTable.AbstractDataTable;
import org.richfaces.ui.iteration.dataTable.MethodExpressionFilteringListener;
import org.richfaces.ui.iteration.dataTable.MethodExpressionSortingListener;

public class DataTableHandler
extends ComponentHandler {
    public DataTableHandler(ComponentConfig config) {
        super(config);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset m = super.createMetaRuleset(type);
        m.addRule((MetaRule)SortingFilteringRule.INSTANCE);
        m.addRule((MetaRule)RowKeyConverterRule.INSTANCE);
        return m;
    }

    static final class FilteringListenerMapper
    extends Metadata {
        private static final Class[] SIGNATURE = new Class[]{FilteringEvent.class};
        private final TagAttribute attribute;

        public FilteringListenerMapper(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((AbstractDataTable)instance).addFilteringListener(new MethodExpressionFilteringListener(this.attribute.getMethodExpression(ctx, null, SIGNATURE)));
        }
    }

    static final class SortingListenerMapper
    extends Metadata {
        private static final Class[] SIGNATURE = new Class[]{SortingEvent.class};
        private final TagAttribute attribute;

        public SortingListenerMapper(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((AbstractDataTable)instance).addSortingListener(new MethodExpressionSortingListener(this.attribute.getMethodExpression(ctx, null, SIGNATURE)));
        }
    }

    static class SortingFilteringRule
    extends MetaRule {
        private static final SortingFilteringRule INSTANCE = new SortingFilteringRule();

        SortingFilteringRule() {
        }

        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(AbstractDataTable.class)) {
                if ("sortingListener".equals(name)) {
                    return new SortingListenerMapper(attribute);
                }
                if ("filteringListener".equals(name)) {
                    return new FilteringListenerMapper(attribute);
                }
            }
            return null;
        }
    }
}

