/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.tree;

import com.google.common.base.Strings;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import org.richfaces.ui.iteration.RowKeyConverterRule;
import org.richfaces.ui.iteration.tree.AbstractTree;
import org.richfaces.ui.iteration.tree.AbstractTreeNode;
import org.richfaces.ui.iteration.tree.TreeSelectionChangeListenerExpressionMetadata;
import org.richfaces.ui.iteration.tree.TreeToggleListenerExpressionMetadata;

public class TreeHandler
extends ComponentHandler {
    private static final MetaRule RULE = new MetaRule(){

        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(AbstractTree.class)) {
                if ("selectionChangeListener".equals(name)) {
                    return new TreeSelectionChangeListenerExpressionMetadata(attribute);
                }
                if ("toggleListener".equals(name)) {
                    return new TreeToggleListenerExpressionMetadata(attribute);
                }
            }
            return null;
        }
    };

    public TreeHandler(ComponentConfig config) {
        super(config);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset metaRuleset = super.createMetaRuleset(type);
        metaRuleset.addRule(RULE);
        metaRuleset.addRule((MetaRule)RowKeyConverterRule.INSTANCE);
        return metaRuleset;
    }

    public void onComponentPopulated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        super.onComponentPopulated(ctx, c, parent);
        UIComponent defaultTreeNode = c.getFacet("__defaultTreeNode");
        if (defaultTreeNode == null) {
            String var = ((AbstractTree)c).getVar();
            if (Strings.isNullOrEmpty((String)var)) {
                return;
            }
            FacesContext facesContext = ctx.getFacesContext();
            Application application = facesContext.getApplication();
            AbstractTreeNode treeNode = (AbstractTreeNode)application.createComponent("org.richfaces.TreeNode");
            treeNode.setId("__defaultTreeNode");
            c.getFacets().put("__defaultTreeNode", treeNode);
            UIComponent text = application.createComponent("javax.faces.HtmlOutputText");
            text.setValueExpression("value", application.getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{" + var + "}", String.class));
            treeNode.getChildren().add(text);
        }
    }
}

