/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.tree;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.javascript.JSFunction;
import org.richfaces.javascript.JSReference;
import org.richfaces.javascript.ScriptStringBase;
import org.richfaces.javascript.ScriptUtils;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.ui.common.ComponentAttribute;
import org.richfaces.ui.common.SwitchType;
import org.richfaces.ui.iteration.tree.AbstractTree;
import org.richfaces.ui.iteration.tree.AbstractTreeNode;
import org.richfaces.ui.iteration.tree.TreeRendererBase;

public final class TreeRenderingContext {
    private static final String ATTRIBUTE_NAME = TreeRenderingContext.class.getName() + ":ATTRIBUTE_NAME";
    private static final ComponentAttribute ONTOGGLE_ATTRIBUTE = new ComponentAttribute("ontoggle").setEventNames("toggle");
    private static final ComponentAttribute ONNODETOGGLE_ATTRIBUTE = new ComponentAttribute("onnodetoggle").setEventNames("nodetoggle");
    private static final ComponentAttribute ONBEFORETOGGLE_ATTRIBUTE = new ComponentAttribute("onbeforetoggle").setEventNames("beforetoggle");
    private static final ComponentAttribute ONBEFORENODETOGGLE_ATTRIBUTE = new ComponentAttribute("onbeforenodetoggle").setEventNames("beforenodetoggle");
    private FacesContext context;
    private AbstractTree tree;
    private String baseClientId;
    private Map<String, Handlers> handlersMap = new HashMap<String, Handlers>();
    private Handlers handlers;

    private TreeRenderingContext(FacesContext context, AbstractTree tree) {
        this.context = context;
        this.tree = tree;
        this.baseClientId = tree.getClientId(context);
    }

    public static TreeRenderingContext create(FacesContext context, AbstractTree tree) {
        TreeRenderingContext renderingContext = new TreeRenderingContext(context, tree);
        context.getAttributes().put(ATTRIBUTE_NAME, renderingContext);
        return renderingContext;
    }

    public static TreeRenderingContext get(FacesContext context) {
        return (TreeRenderingContext)context.getAttributes().get(ATTRIBUTE_NAME);
    }

    public static void delete(FacesContext context) {
        context.getAttributes().remove(ATTRIBUTE_NAME);
    }

    private Handlers getOrCreateHandlers(String relativeClientId) {
        if (this.handlers == null) {
            this.handlers = new Handlers();
            this.handlersMap.put(relativeClientId, this.handlers);
        }
        return this.handlers;
    }

    public void addHandlers(AbstractTreeNode treeNode) {
        this.handlers = null;
        String clientId = treeNode.getClientId(this.context);
        String relativeClientId = clientId.substring(this.baseClientId.length());
        if (TreeRendererBase.getToggleTypeOrDefault(this.tree) != SwitchType.server) {
            String beforeNodeToggleHandler;
            String nodeToggleHandler;
            String beforeToggleHandler;
            String toggleHandler = (String)RenderKitUtils.getAttributeAndBehaviorsValue(this.context, (UIComponent)treeNode, ONTOGGLE_ATTRIBUTE);
            if (!Strings.isNullOrEmpty((String)toggleHandler)) {
                this.getOrCreateHandlers(relativeClientId).setToggleHandler(toggleHandler);
            }
            if (!Strings.isNullOrEmpty((String)(beforeToggleHandler = (String)RenderKitUtils.getAttributeAndBehaviorsValue(this.context, (UIComponent)treeNode, ONBEFORETOGGLE_ATTRIBUTE)))) {
                this.getOrCreateHandlers(relativeClientId).setBeforeToggleHandler(beforeToggleHandler);
            }
            if (!Strings.isNullOrEmpty((String)(nodeToggleHandler = (String)RenderKitUtils.getAttributeAndBehaviorsValue(this.context, (UIComponent)this.tree, ONNODETOGGLE_ATTRIBUTE)))) {
                this.getOrCreateHandlers(relativeClientId).setNodeToggleHandler(nodeToggleHandler);
            }
            if (!Strings.isNullOrEmpty((String)(beforeNodeToggleHandler = (String)RenderKitUtils.getAttributeAndBehaviorsValue(this.context, (UIComponent)this.tree, ONBEFORENODETOGGLE_ATTRIBUTE)))) {
                this.getOrCreateHandlers(relativeClientId).setBeforeNodeToggleHandler(beforeNodeToggleHandler);
            }
        }
    }

    public Object getHandlers() {
        return this.handlersMap;
    }

    public static final class Handlers
    extends ScriptStringBase {
        private String toggleHandler;
        private String nodeToggleHandler;
        private String beforeToggleHandler;
        private String beforeNodeToggleHandler;

        protected Object chain(String firstHandler, String secondHandler) {
            if (Strings.isNullOrEmpty((String)firstHandler) && Strings.isNullOrEmpty((String)secondHandler)) {
                return null;
            }
            if (Strings.isNullOrEmpty((String)firstHandler)) {
                return secondHandler;
            }
            if (Strings.isNullOrEmpty((String)secondHandler)) {
                return firstHandler;
            }
            return new JSFunction("return jsf.util.chain", JSReference.THIS, JSReference.EVENT, firstHandler, secondHandler).toScript();
        }

        public void setToggleHandler(String toggleHandler) {
            this.toggleHandler = toggleHandler;
        }

        public String getToggleHandler() {
            return this.toggleHandler;
        }

        public void setNodeToggleHandler(String nodeToggleHandler) {
            this.nodeToggleHandler = nodeToggleHandler;
        }

        public String getNodeToggleHandler() {
            return this.nodeToggleHandler;
        }

        public void setBeforeToggleHandler(String beforeToggleHandler) {
            this.beforeToggleHandler = beforeToggleHandler;
        }

        public String getBeforeToggleHandler() {
            return this.beforeToggleHandler;
        }

        public void setBeforeNodeToggleHandler(String beforeNodeToggleHandler) {
            this.beforeNodeToggleHandler = beforeNodeToggleHandler;
        }

        public String getBeforeNodeToggleHandler() {
            return this.beforeNodeToggleHandler;
        }

        @Override
        public void appendScript(Appendable target) throws IOException {
            Object chainedToggleHandler = this.chain(this.toggleHandler, this.nodeToggleHandler);
            Object chainedBeforeToggleHandler = this.chain(this.beforeToggleHandler, this.beforeNodeToggleHandler);
            if (chainedToggleHandler != null || chainedBeforeToggleHandler != null) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                if (chainedToggleHandler != null) {
                    map.put("th", chainedToggleHandler);
                }
                if (chainedBeforeToggleHandler != null) {
                    map.put("bth", chainedBeforeToggleHandler);
                }
                ScriptUtils.appendScript(target, map);
            } else {
                ScriptUtils.appendScript(target, null);
            }
        }
    }
}

