/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.select;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.ui.select.SelectItemsInterface;
import org.richfaces.util.RendererUtils;

public final class SelectUtils {
    private static final Logger LOG = RichfacesLogger.APPLICATION.getLogger();

    private SelectUtils() {
    }

    public static Iterator<SelectItem> getSelectItems(FacesContext context, UIComponent component) {
        Iterator children = component.getChildren().iterator();
        if (component instanceof SelectItemsInterface) {
            UnmodifiableIterator self = Iterators.singletonIterator((Object)component);
            children = Iterators.concat((Iterator)self, children);
        }
        SelectItemsIterator iterator = new SelectItemsIterator(context, children);
        return iterator;
    }

    private static final class SelectItemsIterator
    extends AbstractIterator<SelectItem> {
        private Iterator<UIComponent> children;
        private Iterator<SelectItem> items = Iterators.emptyIterator();
        private FacesContext context;

        public SelectItemsIterator(FacesContext context, Iterator<UIComponent> children) {
            this.context = context;
            this.children = children;
        }

        protected SelectItem computeNext() {
            while (this.items.hasNext() || this.children.hasNext()) {
                if (this.items.hasNext()) {
                    SelectItem nextItem = this.items.next();
                    if (!this.items.hasNext()) {
                        this.items = Iterators.emptyIterator();
                    }
                    return nextItem;
                }
                this.items = this.createIterator(this.children.next());
            }
            return (SelectItem)this.endOfData();
        }

        private Iterator<SelectItem> createUISelectItemIterator(UISelectItem selectItem) {
            Object value = selectItem.getValue();
            SelectItem result = null;
            if (value == null) {
                result = new SelectItem(selectItem.getItemValue(), selectItem.getItemLabel(), selectItem.getItemDescription(), selectItem.isItemDisabled(), selectItem.isItemEscaped(), selectItem.isNoSelectionOption());
            } else if (value instanceof SelectItem) {
                result = (SelectItem)value;
            } else {
                ValueExpression expression = selectItem.getValueExpression("value");
                throw new IllegalArgumentException("ValueExpression '" + (expression == null ? null : expression.getExpressionString()) + "' of UISelectItem : " + RichfacesLogger.getComponentPath((UIComponent)selectItem) + " does not reference an Object of type SelectItem");
            }
            return Iterators.singletonIterator((Object)result);
        }

        private Iterator<SelectItem> createSelectItemsIterator(UIComponent component, Object value) {
            if (value == null) {
                return Iterators.emptyIterator();
            }
            if (value instanceof SelectItem) {
                return Iterators.singletonIterator((Object)((SelectItem)value));
            }
            if (value instanceof Object[]) {
                UnmodifiableIterator data = Iterators.forArray((Object[])((Object[])value));
                return new GenericItemsIterator(this.context, component, (Iterator<?>)data);
            }
            if (value instanceof Iterable) {
                Iterator data = ((Iterable)value).iterator();
                return new GenericItemsIterator(this.context, component, data);
            }
            if (value instanceof Map) {
                return new MapItemsIterator((Map)value);
            }
            Logger.Level level = Logger.Level.INFO;
            if (!this.context.isProjectStage(ProjectStage.Production)) {
                level = Logger.Level.WARNING;
            }
            if (LOG.isLogEnabled(level)) {
                ValueExpression expression = component.getValueExpression("value");
                LOG.log(level, String.format("ValueExpression %s of UISelectItems with component-path %s does not reference an Object of type SelectItem, array, Iterable or Map, but of type: %s", expression == null ? null : expression.getExpressionString(), RichfacesLogger.getComponentPath(component), value == null ? null : value.getClass().getName()));
            }
            return Iterators.emptyIterator();
        }

        private Iterator<SelectItem> createUISelectItemsIterator(UISelectItems selectItems) {
            Object value = selectItems.getValue();
            return this.createSelectItemsIterator((UIComponent)selectItems, value);
        }

        private Iterator<SelectItem> createUISelectItemsInterfaceIterator(UIComponent component) {
            Object value = ((SelectItemsInterface)component).getItemValues();
            return this.createSelectItemsIterator(component, value);
        }

        private Iterator<SelectItem> createIterator(UIComponent child) {
            if (!child.isRendered()) {
                return Iterators.emptyIterator();
            }
            if (child instanceof UISelectItem) {
                return this.createUISelectItemIterator((UISelectItem)child);
            }
            if (child instanceof UISelectItems) {
                return this.createUISelectItemsIterator((UISelectItems)child);
            }
            if (child instanceof SelectItemsInterface) {
                return this.createUISelectItemsInterfaceIterator(child);
            }
            return Iterators.emptyIterator();
        }
    }

    private static final class GenericItemsIterator
    extends AbstractIterator<SelectItem> {
        private FacesContext facesContext;
        private UIComponent component;
        private Iterator<?> data;

        public GenericItemsIterator(FacesContext facesContext, UIComponent component, Iterator<?> data) {
            this.facesContext = facesContext;
            this.component = component;
            this.data = data;
        }

        protected SelectItem computeNext() {
            if (this.data.hasNext()) {
                Object next = this.data.next();
                if (next instanceof SelectItem) {
                    return (SelectItem)next;
                }
                GenericObjectSelectItem genericItem = new GenericObjectSelectItem();
                genericItem.updateItem(this.facesContext, this.component, next);
                return genericItem;
            }
            return (SelectItem)this.endOfData();
        }
    }

    private static final class MapItemsIterator
    extends AbstractIterator<SelectItem> {
        private Iterator<?> data;

        public MapItemsIterator(Map<?, ?> map) {
            this.data = map.entrySet().iterator();
        }

        protected SelectItem computeNext() {
            if (this.data.hasNext()) {
                Map.Entry next = (Map.Entry)this.data.next();
                return new SelectItem(next.getValue(), next.getKey().toString());
            }
            return (SelectItem)this.endOfData();
        }
    }

    private static final class GenericObjectSelectItem
    extends SelectItem {
        private static final long serialVersionUID = -714217221281952395L;
        private static final RendererUtils UTILS = RendererUtils.getInstance();
        private static final String VAR = "var";
        private static final String ITEM_VALUE = "itemValue";
        private static final String ITEM_LABEL = "itemLabel";
        private static final String ITEM_DESCRIPTION = "itemDescription";
        private static final String ITEM_ESCAPED = "itemLabelEscaped";
        private static final String ITEM_DISABLED = "itemDisabled";
        private static final String NO_SELECTION_OPTION = "noSelectionOption";

        private GenericObjectSelectItem() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateItem(FacesContext facesContext, UIComponent sourceComponent, Object value) {
            String var = (String)sourceComponent.getAttributes().get(VAR);
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            Object oldVarValue = null;
            if (var != null) {
                oldVarValue = requestMap.put(var, value);
            }
            try {
                Map attrs = sourceComponent.getAttributes();
                Object itemValueResult = attrs.get(ITEM_VALUE);
                Object itemLabelResult = attrs.get(ITEM_LABEL);
                Object itemDescriptionResult = attrs.get(ITEM_DESCRIPTION);
                this.setValue(itemValueResult != null ? itemValueResult : value);
                this.setLabel(itemLabelResult != null ? itemLabelResult.toString() : value.toString());
                this.setDescription(itemDescriptionResult != null ? itemDescriptionResult.toString() : null);
                this.setEscape(UTILS.isBooleanAttribute(sourceComponent, ITEM_ESCAPED));
                this.setDisabled(UTILS.isBooleanAttribute(sourceComponent, ITEM_DISABLED));
                this.setNoSelectionOption(UTILS.isBooleanAttribute(sourceComponent, NO_SELECTION_OPTION));
            }
            finally {
                if (var != null) {
                    if (oldVarValue != null) {
                        requestMap.put(var, oldVarValue);
                    } else {
                        requestMap.remove(var);
                    }
                }
            }
        }
    }
}

