/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.select.inplaceSelect;

import java.io.IOException;
import java.util.List;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.ui.common.InplaceComponent;
import org.richfaces.ui.input.inplaceInput.InplaceInputRendererBase;
import org.richfaces.ui.select.ClientSelectItem;
import org.richfaces.ui.select.SelectHelper;
import org.richfaces.ui.select.inplaceSelect.AbstractInplaceSelect;
import org.richfaces.util.HtmlDimensions;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(name="jquery.position.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-selection.js"), @ResourceDependency(library="org.richfaces", name="inputBase.js"), @ResourceDependency(library="org.richfaces", name="inplaceBase.js"), @ResourceDependency(library="org.richfaces", name="popup.js"), @ResourceDependency(library="org.richfaces", name="list.js"), @ResourceDependency(library="org.richfaces", name="popupList.js"), @ResourceDependency(library="org.richfaces", name="inplaceInput.js"), @ResourceDependency(library="org.richfaces", name="inplaceSelect.js"), @ResourceDependency(library="org.richfaces", name="inplaceSelect.ecss")})
public class InplaceSelectRendererBase
extends InplaceInputRendererBase {
    public static final String ITEM_CSS = "rf-is-opt";

    public List<ClientSelectItem> getConvertedSelectItems(FacesContext facesContext, UIComponent component) {
        return SelectHelper.getConvertedSelectItems(facesContext, component);
    }

    public void encodeItems(FacesContext facesContext, UIComponent component, List<ClientSelectItem> clientSelectItems) throws IOException {
        SelectHelper.encodeItems(facesContext, component, clientSelectItems, "span", ITEM_CSS);
    }

    public void renderListHandlers(FacesContext facesContext, UIComponent component) throws IOException {
        RenderKitUtils.renderPassThroughAttributesOptimized(facesContext, component, SelectHelper.SELECT_LIST_HANDLER_ATTRIBUTES);
    }

    @Override
    public void renderInputHandlers(FacesContext facesContext, UIComponent component) throws IOException {
        RenderKitUtils.renderPassThroughAttributesOptimized(facesContext, component, INPLACE_INPUT_HANDLER_ATTRIBUTES);
    }

    public String getSelectInputLabel(FacesContext facesContext, UIComponent component) {
        return SelectHelper.getSelectInputLabel(facesContext, component);
    }

    public String getListWidth(UIComponent component) {
        AbstractInplaceSelect select = (AbstractInplaceSelect)component;
        String width = this.getListWidth(select);
        return width != null && width.trim().length() != 0 ? "width: " + width : "";
    }

    protected String getListWidth(AbstractInplaceSelect select) {
        String width = HtmlDimensions.formatSize(select.getListWidth());
        if (width == null || width.length() == 0) {
            width = "200px";
        }
        return width;
    }

    protected String getListHeight(AbstractInplaceSelect select) {
        String height = HtmlDimensions.formatSize(select.getListHeight());
        if (height == null || height.length() == 0) {
            height = "100px";
        }
        return height;
    }

    public String getListHeight(UIComponent component) {
        AbstractInplaceSelect select = (AbstractInplaceSelect)component;
        String height = this.getListHeight(select);
        return height != null && height.trim().length() != 0 ? "height: " + height : "";
    }

    public String getSelectLabel(FacesContext facesContext, UIComponent component) {
        AbstractInplaceSelect select = (AbstractInplaceSelect)component;
        String label = this.getSelectInputLabel(facesContext, (UIComponent)select);
        if (!select.isDisabled() && label == null) {
            label = select.getDefaultLabel();
        }
        return label;
    }

    @Override
    public String getContainerStyleClasses(UIComponent component) {
        InplaceComponent inplaceComponent = (InplaceComponent)component;
        String style = this.concatClasses("rf-is", component.getAttributes().get("styleClass"));
        if (inplaceComponent.isDisabled()) {
            style = this.concatClasses(style, this.getDisableStateCss(inplaceComponent));
        }
        return style;
    }

    @Override
    public String getEditStateCss(InplaceComponent component) {
        String css = component.getActiveClass();
        return this.concatClasses("rf-is-act", css);
    }

    @Override
    public String getChangedStateCss(InplaceComponent component) {
        String css = component.getChangedClass();
        return this.concatClasses("rf-is-chng", css);
    }

    @Override
    public String getDisableStateCss(InplaceComponent component) {
        String css = component.getDisabledClass();
        return this.concatClasses("rf-is-dis", css);
    }

    public String getDisabledCss(UIComponent component) {
        AbstractInplaceSelect inplaceSelect = (AbstractInplaceSelect)component;
        return this.getDisableStateCss(inplaceSelect);
    }

    @Override
    public String getEditCss(InplaceComponent component) {
        return "rf-is-fld-cntr";
    }

    @Override
    public String getNoneCss(InplaceComponent component) {
        return "rf-is-none";
    }

    public String getListCss(UIComponent component) {
        AbstractInplaceSelect inplaceSelect = (AbstractInplaceSelect)component;
        String css = inplaceSelect.getListClass();
        css = css != null ? this.concatClasses("rf-is-lst-cord", css) : "rf-is-lst-cord";
        return css;
    }

    protected String getInputWidthStyle(UIComponent component) {
        String value = ((AbstractInplaceSelect)component).getInputWidth();
        if (value == null || "".equals(value)) {
            return "";
        }
        return "width: " + HtmlDimensions.formatSize(value) + ";";
    }
}

