/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.toggle.togglePanel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.javascript.JSObject;
import org.richfaces.ui.common.DivPanelRenderer;
import org.richfaces.ui.toggle.AbstractTogglePanelItemInterface;
import org.richfaces.ui.toggle.togglePanel.AbstractTogglePanel;
import org.richfaces.ui.toggle.togglePanel.AbstractTogglePanelItem;
import org.richfaces.ui.toggle.togglePanel.TogglePanelRenderer;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="togglePanelItem.js")})
public class TogglePanelItemRenderer
extends DivPanelRenderer {
    private static final String LEAVE = "leave";
    private static final String ENTER = "enter";
    private final boolean hideInactiveItems;

    public TogglePanelItemRenderer() {
        this(true);
    }

    protected TogglePanelItemRenderer(boolean hideInactiveItems) {
        this.hideInactiveItems = hideInactiveItems;
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return this.concatClasses("rf-tgp-itm", TogglePanelItemRenderer.attributeAsString(component, "styleClass"));
    }

    @Override
    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.TogglePanelItem", component.getClientId(context), this.getScriptObjectOptions(context, component));
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        AbstractTogglePanelItemInterface panelItem = (AbstractTogglePanelItemInterface)component;
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("name", panelItem.getName());
        options.put("togglePanelId", panelItem.getParentPanel().getClientId(context));
        options.put("switchMode", (Object)panelItem.getSwitchType());
        AbstractTogglePanel panel = panelItem.getParentPanel();
        options.put("index", panel.getIndexByName(panelItem.getName()));
        TogglePanelRenderer.addEventOption(context, component, options, LEAVE);
        TogglePanelRenderer.addEventOption(context, component, options, ENTER);
        return options;
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractTogglePanelItem.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodePlaceHolder(FacesContext context, UIComponent item) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)item.getClientId(context), null);
        writer.writeAttribute("style", (Object)"display:none;", null);
        writer.endElement("div");
    }

    protected void encodePlaceHolderWithJs(FacesContext context, UIComponent item) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)item.getClientId(context), null);
        writer.writeAttribute("style", (Object)"display:none;", null);
        this.writeJavaScript(writer, context, item);
        writer.endElement("div");
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        if (((AbstractTogglePanelItemInterface)component).shouldProcess()) {
            this.doEncodeItemBegin(writer, context, component);
        }
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        if (((AbstractTogglePanelItemInterface)component).shouldProcess()) {
            this.renderChildren(context, component);
        }
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        if (((AbstractTogglePanelItemInterface)component).shouldProcess()) {
            this.doEncodeItemEnd(writer, context, component);
        } else {
            this.encodePlaceHolderWithJs(context, component);
        }
    }

    @Override
    protected String getStyle(UIComponent component) {
        String attributeStyle = super.getStyle(component);
        if (this.hideInactiveItems && !((AbstractTogglePanelItemInterface)component).isActive()) {
            return this.concatStyles(attributeStyle, "display: none");
        }
        return attributeStyle;
    }
}

