/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.validation.validator;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.richfaces.javascript.JSFunction;
import org.richfaces.javascript.ScriptString;
import org.richfaces.javascript.ScriptStringBase;
import org.richfaces.validator.Message;

public class MessageUpdateScript
extends ScriptStringBase
implements ScriptString {
    private final List<Message> messages;
    private final String clientId;

    public MessageUpdateScript(String clientId, List<Message> messages) {
        this.clientId = clientId;
        this.messages = Lists.newArrayList(messages);
    }

    @Override
    public void appendScript(Appendable target) throws IOException {
        JSFunction resetMessages = new JSFunction("RichFaces.csv.clearMessage", this.clientId);
        resetMessages.appendScript(target);
        target.append(';');
        for (Message message : this.messages) {
            JSFunction sendMessage = new JSFunction("RichFaces.csv.sendMessage", this.clientId, message);
            sendMessage.appendScript(target);
            target.append(';');
        }
    }
}

