/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.calendar.RichFacesAdvancedInlineCalendar;
import org.richfaces.fragment.calendar.TimeEditor;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;

public class FooterControls {
    @Root
    private WebElement root;
    private RichFacesAdvancedInlineCalendar.CalendarEditor calendarEditor;
    @FindByJQuery(value="div.rf-cal-tl-btn:contains('Clean')")
    private GrapheneElement cleanButtonElement;
    @FindBy(css="td.rf-cal-tl-ftr > div[onclick*='showTimeEditor']")
    private GrapheneElement timeEditorOpenerElement;
    @FindBy(css="td.rf-cal-tl-ftr > div[onclick*='showSelectedDate']")
    private GrapheneElement selectedDateElement;
    @FindByJQuery(value="div.rf-cal-tl-btn:contains('Today')")
    private GrapheneElement todayButtonElement;

    private void _openTimeEditor() {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot open time editor. Ensure that calendar popup and footer controls are displayed.");
        }
        if (!this.getTimeEditorOpenerElement().isDisplayed()) {
            throw new RuntimeException("Cannot open time editor. Ensure that the date is set before setting time.");
        }
        this.getTimeEditorOpenerElement().click();
        this.getCalendarEditor().getTimeEditor().waitUntilIsVisible().perform();
    }

    public void cleanDate() {
        if (!this.isVisible()) {
            throw new RuntimeException("Footer controls are not displayed, cannot interact with  clean button");
        }
        if (!this.getCleanButtonElement().isDisplayed()) {
            throw new RuntimeException("Clean button is not displayed.");
        }
        this.getCleanButtonElement().click();
        ((IsElementBuilder)Graphene.waitGui().until().element(this.getCleanButtonElement()).is().not()).visible();
    }

    public WebElement getCleanButtonElement() {
        return this.cleanButtonElement;
    }

    public TimeEditor getTimeEditor() {
        return this.getCalendarEditor().getTimeEditor();
    }

    public WebElement getTimeEditorOpenerElement() {
        return this.timeEditorOpenerElement;
    }

    public WebElement getTodayButtonElement() {
        return this.todayButtonElement;
    }

    public WebElement getSelectedDateElement() {
        return this.selectedDateElement;
    }

    public boolean isVisible() {
        return Utils.isVisible(this.getRoot());
    }

    public TimeEditor openTimeEditor() {
        if (Utils.isVisible(this.getCalendarEditor().getTimeEditor().getRootElement())) {
            return this.getCalendarEditor().getTimeEditor();
        }
        this._openTimeEditor();
        return this.getCalendarEditor().getTimeEditor();
    }

    public void setCalendarEditor(RichFacesAdvancedInlineCalendar.CalendarEditor calendarEditor) {
        this.calendarEditor = calendarEditor;
    }

    public void setTodaysDate() {
        this.todayDate();
    }

    public void todayDate() {
        if (!this.isVisible()) {
            throw new RuntimeException("Footer controls are not displayed, cannot interact with today button");
        }
        if (!this.getTodayButtonElement().isDisplayed()) {
            throw new RuntimeException("Today button is not displayed.");
        }
        this.getTodayButtonElement().click();
    }

    public WaitingWrapper waitUntilIsNotVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                ((IsElementBuilder)wait.until().element(FooterControls.this.getRoot()).is().not()).visible();
            }
        }.withMessage("Footer controls to be not visible.");
    }

    public WaitingWrapper waitUntilIsVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                wait.until().element(FooterControls.this.getRoot()).is().visible();
            }
        }.withMessage("Footer controls to be visible.");
    }

    public WebElement getRoot() {
        return this.root;
    }

    protected RichFacesAdvancedInlineCalendar.CalendarEditor getCalendarEditor() {
        return this.calendarEditor;
    }
}

