/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.collapsibleSubTable;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.collapsibleSubTable.CollapsibleSubTable;
import org.richfaces.fragment.collapsibleSubTableToggler.RichFacesCollapsibleSubTableToggler;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.dataTable.AbstractTable;

public abstract class RichFacesCollapsibleSubTable<HEADER, ROW, FOOTER>
extends AbstractTable<HEADER, ROW, FOOTER>
implements CollapsibleSubTable<HEADER, ROW, FOOTER> {
    private final AdvancedCollapsibleSubTableInteractions interactions = new AdvancedCollapsibleSubTableInteractions();

    @Override
    public AdvancedCollapsibleSubTableInteractions advanced() {
        return this.interactions;
    }

    @Override
    public CollapsibleSubTable<HEADER, ROW, FOOTER> collapse() {
        if (this.advanced().isExpanded()) {
            this.advanced().getTableToggler().toggle();
        }
        this.advanced().waitUntilTableCollapses().perform();
        return this;
    }

    @Override
    public CollapsibleSubTable<HEADER, ROW, FOOTER> expand() {
        if (!this.advanced().isExpanded()) {
            this.advanced().getTableToggler().toggle();
        }
        this.advanced().waitUntilTableExpands().perform();
        return this;
    }

    public class AdvancedCollapsibleSubTableInteractions
    extends AbstractTable.AdvancedTableInteractions {
        private long timeoutForTableToCollapse = -1L;
        private long timeoutForTableToExpand = -1L;
        private WebElement cstRootElement;
        private WebElement tableHeader;
        private WebElement tableFooter;
        private WebElement noData;
        private List<WebElement> tableRows;
        private List<WebElement> firstRowCells;
        private RichFacesCollapsibleSubTableToggler toggleElement;

        public WebElement getTableRootElement() {
            if (this.cstRootElement == null) {
                WebElement datatableParent = Utils.getAncestorOfElement(RichFacesCollapsibleSubTable.this.root, "table");
                WebElement firstToggler = Utils.getAncestorOfElement(datatableParent.findElement(By.className((String)"rf-csttg")), "tbody");
                WebElement firstCST = datatableParent.findElement(By.className((String)"rf-cst"));
                boolean isTogglerBeforeCST = Utils.getIndexOfElement(firstCST) > Utils.getIndexOfElement(firstToggler);
                WebElement togglerTbodyRoot = Utils.getAncestorOfElement(RichFacesCollapsibleSubTable.this.root, "tbody");
                this.cstRootElement = isTogglerBeforeCST ? Utils.getNextSiblingOfElement(togglerTbodyRoot, "tbody") : Utils.getPreviousSiblingOfElement(togglerTbodyRoot, "tbody");
            }
            return this.cstRootElement;
        }

        public RichFacesCollapsibleSubTableToggler getTableToggler() {
            if (this.toggleElement == null) {
                this.toggleElement = (RichFacesCollapsibleSubTableToggler)Graphene.createPageFragment(RichFacesCollapsibleSubTableToggler.class, (WebElement)RichFacesCollapsibleSubTable.this.root);
            }
            return this.toggleElement;
        }

        @Override
        public List<WebElement> getColumnFooterElements() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<WebElement> getColumnHeaderElements() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<WebElement> getFirstRowCellsElements() {
            if (this.firstRowCells == null) {
                this.firstRowCells = RichFacesCollapsibleSubTable.this.advanced().getTableRootElement().findElements((By)ByJQuery.selector((String)".rf-cst-r:first .rf-cst-c"));
            }
            return Collections.unmodifiableList(this.firstRowCells);
        }

        @Override
        public WebElement getFooterElement() {
            if (this.tableFooter == null) {
                this.tableFooter = RichFacesCollapsibleSubTable.this.advanced().getTableRootElement().findElement(By.className((String)"rf-cst-ftr"));
            }
            return this.tableFooter;
        }

        @Override
        public WebElement getHeaderElement() {
            if (this.tableHeader == null) {
                this.tableHeader = RichFacesCollapsibleSubTable.this.advanced().getTableRootElement().findElement(By.className((String)"rf-cst-hdr"));
            }
            return this.tableHeader;
        }

        @Override
        public WebElement getNoDataElement() {
            if (this.noData == null) {
                this.noData = RichFacesCollapsibleSubTable.this.advanced().getTableRootElement().findElement((By)ByJQuery.selector((String)".rf-cst-nd > .rf-cst-nd-c"));
            }
            return this.noData;
        }

        @Override
        public By getSelectorForCell(int column) {
            return ByJQuery.selector((String)String.format("rf-cst-c:eq(%s)", column));
        }

        @Override
        public List<WebElement> getTableRowsElements() {
            if (this.tableRows == null) {
                this.tableRows = RichFacesCollapsibleSubTable.this.advanced().getTableRootElement().findElements(By.className((String)"rf-cst-r"));
            }
            return Collections.unmodifiableList(this.tableRows);
        }

        @Override
        public WebElement getWholeTableFooterElement() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public WebElement getWholeTableHeaderElement() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isExpanded() {
            return this.getTableToggler().isExpanded();
        }

        @Override
        public boolean isVisible() {
            try {
                return Utils.isVisible(this.getTableRootElement());
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public long getTimeoutForTableToCollapse() {
            return this.timeoutForTableToCollapse == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesCollapsibleSubTable.this.browser) : this.timeoutForTableToCollapse;
        }

        public long getTimeoutForTableToExpand() {
            return this.timeoutForTableToExpand == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesCollapsibleSubTable.this.browser) : this.timeoutForTableToExpand;
        }

        public void setupTimeoutForTableToCollapse() {
            this.timeoutForTableToCollapse = -1L;
        }

        public void setupTimeoutForTableToCollapse(long timeoutInMilliseconds) {
            this.timeoutForTableToCollapse = timeoutInMilliseconds;
        }

        public void setupTimeoutForTableToExpand() {
            this.timeoutForTableToExpand = -1L;
        }

        public void setupTimeoutForTableToExpand(long timeoutInMilliseconds) {
            this.timeoutForTableToExpand = timeoutInMilliseconds;
        }

        public WaitingWrapper waitUntilTableCollapses() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return !AdvancedCollapsibleSubTableInteractions.this.isExpanded();
                        }
                    });
                }
            }.withMessage("Waiting for CST to collapse").withTimeout(this.getTimeoutForTableToCollapse(), TimeUnit.MILLISECONDS);
        }

        public WaitingWrapper waitUntilTableExpands() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AdvancedCollapsibleSubTableInteractions.this.isExpanded();
                        }
                    });
                }
            }.withMessage("Waiting for CST to expand").withTimeout(this.getTimeoutForTableToExpand(), TimeUnit.MILLISECONDS);
        }
    }
}

