/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.Graphene;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.richfaces.fragment.common.Event;
import org.richfaces.fragment.common.Utils;

public class Actions
extends org.openqa.selenium.interactions.Actions {
    public Actions(WebDriver driver) {
        super(driver);
    }

    public Actions addAction(Action a) {
        this.action.addAction(a);
        return this;
    }

    public Actions blurByJS(WebElement element) {
        return this.triggerEventByJS(Event.BLUR, element);
    }

    public Actions click(WebElement onElement) {
        super.click(onElement);
        return this;
    }

    public Actions click() {
        super.click();
        return this;
    }

    public Actions clickAndHold(WebElement onElement) {
        super.clickAndHold(onElement);
        return this;
    }

    public Actions clickAndHold() {
        super.clickAndHold();
        return this;
    }

    public Actions contextClick(WebElement onElement) {
        super.contextClick(onElement);
        return this;
    }

    public Actions contextClick() {
        super.contextClick();
        return this;
    }

    public Actions doubleClick(WebElement onElement) {
        super.doubleClick(onElement);
        return this;
    }

    public Actions doubleClick() {
        super.doubleClick();
        return this;
    }

    public Actions dragAndDrop(WebElement source, WebElement target) {
        super.dragAndDrop(source, target);
        return this;
    }

    public Actions dragAndDropBy(WebElement source, int xOffset, int yOffset) {
        super.dragAndDropBy(source, xOffset, yOffset);
        return this;
    }

    public Actions keyDown(Keys theKey) {
        super.keyDown(theKey);
        return this;
    }

    public Actions keyDown(WebElement element, Keys theKey) {
        super.keyDown(element, theKey);
        return this;
    }

    public Actions keyUp(Keys theKey) {
        super.keyUp(theKey);
        return this;
    }

    public Actions keyUp(WebElement element, Keys theKey) {
        super.keyUp(element, theKey);
        return this;
    }

    public Actions moveByOffset(int xOffset, int yOffset) {
        super.moveByOffset(xOffset, yOffset);
        return this;
    }

    public Actions moveToElement(WebElement toElement) {
        super.moveToElement(toElement);
        return this;
    }

    public Actions moveToElement(WebElement toElement, int xOffset, int yOffset) {
        super.moveToElement(toElement, xOffset, yOffset);
        return this;
    }

    public Actions release(WebElement onElement) {
        super.release(onElement);
        return this;
    }

    public Actions release() {
        super.release();
        return this;
    }

    public Actions sendKeys(CharSequence ... keysToSend) {
        super.sendKeys(keysToSend);
        return this;
    }

    public Actions sendKeys(WebElement element, CharSequence ... keysToSend) {
        super.sendKeys(element, keysToSend);
        return this;
    }

    public Actions triggerEventByJS(final Event event, final WebElement element) {
        return this.addAction(new Action(){

            public void perform() {
                Graphene.waitGui().until().element(element).is().present();
                Utils.triggerJQ(event.getEventName(), element);
            }
        });
    }

    public Actions triggerEventByWD(Event event, WebElement element) {
        if (event.equals(Event.CLICK)) {
            return this.click(element);
        }
        if (event.equals(Event.DBLCLICK)) {
            return this.doubleClick(element);
        }
        if (event.equals(Event.MOUSEDOWN)) {
            return this.clickAndHold(element);
        }
        if (event.equals(Event.MOUSEMOVE)) {
            return this.moveToElement(element);
        }
        if (event.equals(Event.CONTEXTCLICK)) {
            return this.contextClick(element);
        }
        if (event.equals(Event.CONTEXTMENU)) {
            return this.contextClick(element);
        }
        if (event.equals(Event.MOUSEOUT)) {
            return this.moveToElement(element).moveByOffset(-1000, -1000);
        }
        if (event.equals(Event.MOUSEOVER)) {
            return this.moveToElement(element, 1, 1);
        }
        if (event.equals(Event.MOUSEUP)) {
            return this.clickAndHold(element).release();
        }
        throw new IllegalArgumentException("Cannot trigger this event " + event + " with WebDriver. Try to use 'triggerEventByJS' instead.");
    }

    public Actions waitAction(long timeInMillis) {
        this.action.addAction((Action)new WaitAction(timeInMillis));
        return this;
    }

    private static class WaitAction
    implements Action {
        private final long timeInMillis;

        public WaitAction(long timeInMillis) {
            this.timeInMillis = timeInMillis;
        }

        public void perform() {
            try {
                Thread.sleep(this.timeInMillis);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Actions.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

