/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.dataGrid;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.TypeResolver;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.dataGrid.DataGrid;

public class RichFacesDataGrid<RECORD>
implements DataGrid<RECORD>,
AdvancedInteractions<AdvancedDataGridInteractions> {
    private static final String CSS_SEL_ROW = ".rf-dg-r";
    private static final String JQUERY_SEL_RECORD = ".rf-dg-c:not(:empty)";
    private static final String JQUERY_SEL_COLUMN = ".rf-dg-c";
    @FindBy(css=".rf-dg-r")
    private List<WebElement> rowElements;
    @FindByJQuery(value=".rf-dg-c:not(:empty)")
    private List<WebElement> recordsElements;
    @FindBy(css=".rf-dg-nd")
    private WebElement noDataElement;
    private final Class<RECORD> recordClass = TypeResolver.resolveRawArguments(DataGrid.class, this.getClass())[0];
    private AdvancedDataGridInteractions advancedInteractions = new AdvancedDataGridInteractions();

    @Override
    public List<RECORD> getRecordsInRow(int rowIndex) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.getNumberOfRows() - 1 > rowIndex) {
            throw new IllegalArgumentException("There is not so many rows! Requesting: " + rowIndex + ", but there is only: " + this.getNumberOfRows());
        }
        List recordsInParticularRow = this.rowElements.get(rowIndex).findElements((By)ByJQuery.selector((String)JQUERY_SEL_RECORD));
        for (WebElement recordRoot : recordsInParticularRow) {
            result.add(Graphene.createPageFragment(this.recordClass, (WebElement)recordRoot));
        }
        return result;
    }

    @Override
    public RECORD getRecord(int n) {
        return (RECORD)Graphene.createPageFragment(this.recordClass, (WebElement)this.recordsElements.get(n));
    }

    @Override
    public int getNumberOfRows() {
        return this.rowElements.size();
    }

    @Override
    public int getNumberOfColumns() {
        if (this.rowElements.isEmpty()) {
            return 0;
        }
        return this.rowElements.get(0).findElements((By)ByJQuery.selector((String)JQUERY_SEL_COLUMN)).size();
    }

    @Override
    public int getNumberOfRecords() {
        return this.recordsElements.size();
    }

    @Override
    public List<RECORD> getAllVisibleRecords() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (WebElement recordRoot : this.recordsElements) {
            result.add(Graphene.createPageFragment(this.recordClass, (WebElement)recordRoot));
        }
        return result;
    }

    @Override
    public AdvancedDataGridInteractions advanced() {
        return this.advancedInteractions;
    }

    public class AdvancedDataGridInteractions {
        public boolean isNoData() {
            return Utils.isVisible(RichFacesDataGrid.this.noDataElement);
        }
    }
}

