/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.inputNumberSlider;

import org.jboss.arquillian.graphene.condition.element.WebElementConditionFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.TextInputComponentImpl;
import org.richfaces.fragment.inputNumberSlider.NumberInput;

public abstract class AbstractNumberInput
implements NumberInput {
    @Override
    public void increase() {
        if (!((Boolean)new WebElementConditionFactory(this.getArrowIncreaseElement()).isVisible().apply((Object)this.getBrowser())).booleanValue()) {
            throw new RuntimeException("Arrow for increasing value is not visible.");
        }
        this.getArrowIncreaseElement().click();
    }

    @Override
    public void decrease() {
        if (!((Boolean)new WebElementConditionFactory(this.getArrowDecreaseElement()).isVisible().apply((Object)this.getBrowser())).booleanValue()) {
            throw new RuntimeException("arrow for decreasing value is not visible.");
        }
        this.getArrowDecreaseElement().click();
    }

    @Override
    public void increase(int n) {
        for (int i = 0; i < n; ++i) {
            this.increase();
        }
    }

    @Override
    public void decrease(int n) {
        for (int i = 0; i < n; ++i) {
            this.decrease();
        }
    }

    @Override
    public void setValue(double value) {
        this.getInput().sendKeys(String.valueOf(value));
    }

    @Override
    public double getValue() {
        return Double.valueOf(this.getInput().getStringValue());
    }

    protected abstract WebElement getArrowIncreaseElement();

    protected abstract WebDriver getBrowser();

    protected abstract WebElement getArrowDecreaseElement();

    protected abstract TextInputComponentImpl getInput();

    public class AdvancedNumberInputInteractions {
        public TextInputComponentImpl getInput() {
            return AbstractNumberInput.this.getInput();
        }

        public WebElement getArrowIncreaseElement() {
            return AbstractNumberInput.this.getArrowIncreaseElement();
        }

        public WebElement getArrowDecreaseElement() {
            return AbstractNumberInput.this.getArrowDecreaseElement();
        }
    }
}

