/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.message;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.message.AbstractMessage;
import org.richfaces.fragment.message.Message;

public class RichFacesMessage
extends AbstractMessage {
    @FindBy(className="rf-msg-det")
    private WebElement messageDetailElement;
    @FindBy(className="rf-msg-sum")
    private WebElement messageSummaryElement;

    @Override
    protected String getCssClass(Message.MessageType type) {
        return RichFacesMessage.getCssClassForMessageType(type);
    }

    public static String getCssClassForMessageType(Message.MessageType type) {
        switch (type) {
            case ERROR: {
                return "rf-msg-err";
            }
            case FATAL: {
                return "rf-msg-ftl";
            }
            case INFORMATION: {
                return "rf-msg-inf";
            }
            case OK: {
                return "rf-msg-ok";
            }
            case WARNING: {
                return "rf-msg-wrn";
            }
        }
        throw new UnsupportedOperationException("Unknown message type " + (Object)((Object)type));
    }

    @Override
    protected WebElement getMessageDetailElement() {
        return this.messageDetailElement;
    }

    @Override
    protected WebElement getMessageSummaryElement() {
        return this.messageSummaryElement;
    }
}

