/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.notify;

import com.google.common.base.Function;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.message.AbstractMessage;
import org.richfaces.fragment.message.Message;
import org.richfaces.fragment.notify.NotifyMessage;

public class RichFacesNotifyMessage
extends AbstractMessage
implements NotifyMessage {
    @Drone
    private WebDriver driver;
    @FindBy(className="rf-ntf-det")
    private WebElement messageDetailElement;
    @FindBy(className="rf-ntf-sum")
    private WebElement messageSummaryElement;
    @FindBy(className="rf-ntf-cls")
    private WebElement closeElement;
    @FindBy(className="rf-ntf-cls-ico")
    private WebElement closeIconElement;
    @FindBy(className="rf-ntf-shdw")
    private WebElement shadowElement;
    private final AdvancedNotifyMessageInteractionsImpl interactions = new AdvancedNotifyMessageInteractionsImpl();

    @Override
    public AdvancedNotifyMessageInteractionsImpl advanced() {
        return this.interactions;
    }

    @Override
    public void close() {
        new Actions(this.driver).moveToElement((WebElement)this.getRootElement()).perform();
        Graphene.waitModel().until().element(this.closeIconElement).is().visible();
        final List messages = this.driver.findElements(By.cssSelector((String)"div.rf-ntf-cnt"));
        final int sizeBefore = messages.size();
        new Actions(this.driver).click(this.closeIconElement).perform();
        Graphene.waitModel().withMessage("The message did not disappear.").until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver input) {
                return messages.size() == sizeBefore - 1;
            }
        });
    }

    @Override
    protected String getCssClass(Message.MessageType type) {
        return RichFacesNotifyMessage.getStyleClassForMessageType(type);
    }

    @Override
    protected WebElement getMessageDetailElement() {
        return this.messageDetailElement;
    }

    @Override
    protected WebElement getMessageSummaryElement() {
        return this.messageSummaryElement;
    }

    public static String getStyleClassForMessageType(Message.MessageType type) {
        switch (type) {
            case ERROR: {
                return "rf-ntf-err";
            }
            case FATAL: {
                return "rf-ntf-ftl";
            }
            case INFORMATION: {
                return "rf-ntf-inf";
            }
            case OK: {
                return "rf-ntf-ok";
            }
            case WARNING: {
                return "rf-ntf-wrn";
            }
        }
        throw new UnsupportedOperationException("Unknown message type " + (Object)((Object)type));
    }

    private static enum RichFacesNotifyMessagePosition {
        BOTTOM_LEFT(NotifyMessage.NotifyMessagePosition.BOTTOM_LEFT, "rf-ntf-pos-bl"),
        BOTTOM_RIGHT(NotifyMessage.NotifyMessagePosition.BOTTOM_RIGHT, "rf-ntf-pos-br"),
        TOP_LEFT(NotifyMessage.NotifyMessagePosition.TOP_LEFT, "rf-ntf-pos-tl"),
        TOP_RIGHT(NotifyMessage.NotifyMessagePosition.TOP_RIGHT, "rf-ntf-pos-tr");

        private final String containsClass;
        private final NotifyMessage.NotifyMessagePosition position;

        private RichFacesNotifyMessagePosition(NotifyMessage.NotifyMessagePosition position, String containsClass) {
            this.position = position;
            this.containsClass = containsClass;
        }

        static NotifyMessage.NotifyMessagePosition getPositionFromElement(WebElement element) {
            String styleClasses = element.getAttribute("class");
            for (RichFacesNotifyMessagePosition messagePosition : RichFacesNotifyMessagePosition.values()) {
                if (!styleClasses.contains(messagePosition.containsClass)) continue;
                return messagePosition.position;
            }
            throw new RuntimeException("Cannot obtain position from element: " + element);
        }
    }

    public class AdvancedNotifyMessageInteractionsImpl
    extends AbstractMessage.AdvancedMessageInteractionsImpl
    implements NotifyMessage.AdvancedNotifyMessageIteractions {
        @Override
        public WebElement getCloseElement() {
            return RichFacesNotifyMessage.this.closeElement;
        }

        @Override
        public WebElement getCloseIconElement() {
            return RichFacesNotifyMessage.this.closeIconElement;
        }

        @Override
        public NotifyMessage.NotifyMessagePosition getPosition() {
            return RichFacesNotifyMessagePosition.getPositionFromElement(this.getRootElement());
        }

        @Override
        public WebElement getShadowElement() {
            return RichFacesNotifyMessage.this.shadowElement;
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }
    }
}

